/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class SOAResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = -5562024832624364745L;
    private String mName;
    private String rName;
    private long serial;
    private long refresh;
    private long retry;
    private long expire;
    private long minimum;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.mName = DNSStringUtil.readNameUsingBuffer(buffer);
            this.rName = DNSStringUtil.readNameUsingBuffer(buffer);
            this.serial = buffer.readUnsignedInt();
            this.refresh = buffer.readUnsignedInt();
            this.retry = buffer.readUnsignedInt();
            this.expire = buffer.readUnsignedInt();
            this.minimum = buffer.readUnsignedInt();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        char rdLength = (char)(this.mName.length() + 2 + (this.rName.length() + 2) + 20);
        buffer.writeChar(rdLength);
        DNSStringUtil.writeName(this.mName, buffer);
        DNSStringUtil.writeName(this.rName, buffer);
        buffer.writeInt((int)this.serial);
        buffer.writeInt((int)this.refresh);
        buffer.writeInt((int)this.retry);
        buffer.writeInt((int)this.expire);
        buffer.writeInt((int)this.minimum);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.mName + " " + this.rName + " " + this.serial + " " + this.refresh + " " + this.retry + " " + this.expire + " " + this.minimum;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("mname", this.mName).add("rname", this.rName).add("serial", this.serial).add("refresh", this.refresh).add("retry", this.retry).add("expire", this.expire).add("minimum", this.minimum)).build();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.expire ^ this.expire >>> 32);
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (int)(this.minimum ^ this.minimum >>> 32);
        result = 31 * result + (this.rName == null ? 0 : this.rName.hashCode());
        result = 31 * result + (int)(this.refresh ^ this.refresh >>> 32);
        result = 31 * result + (int)(this.retry ^ this.retry >>> 32);
        result = 31 * result + (int)(this.serial ^ this.serial >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SOAResourceRecord other = (SOAResourceRecord)obj;
        if (this.expire != other.expire) {
            return false;
        }
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        if (this.minimum != other.minimum) {
            return false;
        }
        if (this.rName == null ? other.rName != null : !this.rName.equals(other.rName)) {
            return false;
        }
        if (this.refresh != other.refresh) {
            return false;
        }
        if (this.retry != other.retry) {
            return false;
        }
        return this.serial == other.serial;
    }

    public String getMName() {
        return this.mName;
    }

    public String getRName() {
        return this.rName;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getRefresh() {
        return this.refresh;
    }

    public long getRetry() {
        return this.retry;
    }

    public long getExpire() {
        return this.expire;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setMName(String mName) {
        this.mName = mName;
    }

    public void setRName(String rName) {
        this.rName = rName;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public void setRefresh(long refresh) {
        this.refresh = refresh;
    }

    public void setRetry(long retry) {
        this.retry = retry;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }
}

