/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.AlgorithmType;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import nl.sidnlabs.dnslib.types.TypeMap;
import nl.sidnlabs.dnslib.util.LabelUtil;
import org.apache.commons.codec.binary.Base64;

public class RRSIGResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private final SimpleDateFormat DATE_FMT = new SimpleDateFormat("YYYYMMddHHmmss");
    private TypeMap typeCovered;
    private AlgorithmType algorithm;
    private short labels;
    private long originalTtl;
    private long signatureExpiration;
    private long signatureInception;
    private char keytag;
    private String signerName;
    private byte[] signature;
    private boolean wildcard;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            char type = buffer.readUnsignedChar();
            ResourceRecordType rrType = ResourceRecordType.fromValue(type);
            if (rrType == null) {
                rrType = ResourceRecordType.RESERVED;
            }
            this.typeCovered = new TypeMap(rrType, type);
            short alg = buffer.readUnsignedByte();
            this.algorithm = AlgorithmType.fromValue(alg);
            this.labels = buffer.readUnsignedByte();
            this.wildcard = LabelUtil.count(this.getName()) > this.labels;
            this.originalTtl = buffer.readUnsignedInt();
            this.signatureExpiration = buffer.readUnsignedInt();
            this.signatureInception = buffer.readUnsignedInt();
            this.keytag = buffer.readUnsignedChar();
            this.signerName = DNSStringUtil.readNameUsingBuffer(buffer);
            int signatureLength = this.rdLength;
            signatureLength = this.signerName.length() == 1 ? --signatureLength : (signatureLength -= this.signerName.length() + 1);
            this.signature = new byte[signatureLength -= 18];
            buffer.readBytes(this.signature);
            this.DATE_FMT.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.typeCovered.getValue());
        buffer.writeByte(this.algorithm.getValue());
        buffer.writeByte(this.labels);
        buffer.writeInt((int)this.originalTtl);
        buffer.writeInt((int)this.signatureExpiration);
        buffer.writeInt((int)this.signatureInception);
        buffer.writeChar(this.keytag);
        DNSStringUtil.writeName(this.signerName, buffer);
        buffer.writeBytes(this.signature);
    }

    @Override
    public String toZone(int maxLength) {
        Date exp = new Date();
        exp.setTime(this.signatureExpiration * 1000L);
        Date incep = new Date();
        incep.setTime(this.signatureInception * 1000L);
        SimpleDateFormat fmt = new SimpleDateFormat("YYYYMMddHHmmss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return super.toZone(maxLength) + "\t" + this.typeCovered.name() + " " + this.algorithm.getValue() + " " + this.labels + " " + this.originalTtl + " " + fmt.format(exp) + "(\n\t\t\t\t\t" + fmt.format(incep) + " " + this.keytag + " " + this.signerName + "\n\t\t\t\t\t" + new Base64(36, "\n\t\t\t\t\t".getBytes()).encodeAsString(this.signature) + " )";
    }

    @Override
    public JsonObject toJSon() {
        Date exp = new Date();
        exp.setTime(this.signatureExpiration * 1000L);
        Date incep = new Date();
        incep.setTime(this.signatureInception * 1000L);
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("type-covered", this.typeCovered.name()).add("algorithm", this.algorithm.name()).add("labels", (int)this.labels).add("original-ttl", this.originalTtl).add("sig-exp", this.DATE_FMT.format(exp)).add("sig-inc", this.DATE_FMT.format(incep)).add("keytag", (int)this.keytag).add("signer-name", this.signerName).add("signature", new Base64(Integer.MAX_VALUE, "".getBytes()).encodeAsString(this.signature))).build();
    }

    public boolean getWildcard() {
        return this.wildcard;
    }

    public SimpleDateFormat getDATE_FMT() {
        return this.DATE_FMT;
    }

    public TypeMap getTypeCovered() {
        return this.typeCovered;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public short getLabels() {
        return this.labels;
    }

    public long getOriginalTtl() {
        return this.originalTtl;
    }

    public long getSignatureExpiration() {
        return this.signatureExpiration;
    }

    public long getSignatureInception() {
        return this.signatureInception;
    }

    public char getKeytag() {
        return this.keytag;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setTypeCovered(TypeMap typeCovered) {
        this.typeCovered = typeCovered;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public void setLabels(short labels) {
        this.labels = labels;
    }

    public void setOriginalTtl(long originalTtl) {
        this.originalTtl = originalTtl;
    }

    public void setSignatureExpiration(long signatureExpiration) {
        this.signatureExpiration = signatureExpiration;
    }

    public void setSignatureInception(long signatureInception) {
        this.signatureInception = signatureInception;
    }

    public void setKeytag(char keytag) {
        this.keytag = keytag;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }
}

