/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message;

import javax.json.Json;
import javax.json.JsonObject;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.ResourceRecordClass;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import org.apache.commons.lang3.StringUtils;

public class Question {
    private String qName;
    private ResourceRecordType qType;
    private int qTypeValue;
    private ResourceRecordClass qClass;
    private int qClassValue;

    public Question() {
    }

    public Question(String qName, ResourceRecordType qType, ResourceRecordClass qClass) {
        this.qName = qName;
        this.qType = qType;
        this.qClass = qClass;
    }

    public void decode(NetworkData buffer) {
        String qname = DNSStringUtil.readNameUsingBuffer(buffer);
        this.setQName(qname != null ? StringUtils.lowerCase((String)qname) : "");
        this.qTypeValue = buffer.readUnsignedChar();
        this.setQType(ResourceRecordType.fromValue(this.qTypeValue));
        this.qClassValue = buffer.readUnsignedChar();
        this.setQClass(ResourceRecordClass.fromValue(this.qClassValue));
    }

    public JsonObject toJSon() {
        return Json.createObjectBuilder().add("qName", this.qName).add("qType", this.qType != null ? this.qType.name() : "").add("qClass", this.qClass != null ? this.qClass.name() : "").build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.qClassValue;
        result = 31 * result + (this.qName == null ? 0 : this.qName.hashCode());
        result = 31 * result + this.qTypeValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Question other = (Question)obj;
        if (this.qClassValue != other.qClassValue) {
            return false;
        }
        if (this.qName == null ? other.qName != null : !this.qName.equals(other.qName)) {
            return false;
        }
        return this.qTypeValue == other.qTypeValue;
    }

    public String getQName() {
        return this.qName;
    }

    public ResourceRecordType getQType() {
        return this.qType;
    }

    public int getQTypeValue() {
        return this.qTypeValue;
    }

    public ResourceRecordClass getQClass() {
        return this.qClass;
    }

    public int getQClassValue() {
        return this.qClassValue;
    }

    public void setQName(String qName) {
        this.qName = qName;
    }

    public void setQType(ResourceRecordType qType) {
        this.qType = qType;
    }

    public void setQTypeValue(int qTypeValue) {
        this.qTypeValue = qTypeValue;
    }

    public void setQClass(ResourceRecordClass qClass) {
        this.qClass = qClass;
    }

    public void setQClassValue(int qClassValue) {
        this.qClassValue = qClassValue;
    }
}

