/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class TXTResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    protected String value = "";
    protected byte[] data;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            int bytesRead = 0;
            StringBuilder builder = new StringBuilder();
            while (bytesRead < this.rdLength) {
                short stringLength = buffer.readUnsignedByte();
                this.data = new byte[stringLength];
                buffer.readBytes(this.data);
                builder.append(new String(this.data));
                bytesRead = bytesRead + stringLength + 1;
            }
            this.value = builder.toString();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeByte(this.data.length);
        buffer.writeBytes(this.data);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.value;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("txt-data", this.value)).build();
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

