/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;
import nl.sidnlabs.dnslib.message.records.ResourceRecord;
import nl.sidnlabs.dnslib.types.ResourceRecordClass;
import nl.sidnlabs.dnslib.types.ResourceRecordType;

public class RRset
implements Serializable {
    private static final long serialVersionUID = -8053869237612837919L;
    private List<ResourceRecord> data = new ArrayList<ResourceRecord>();
    private String owner;
    private ResourceRecordClass classz;
    private ResourceRecordType type;

    public RRset() {
    }

    public RRset(String owner, ResourceRecordClass classz, ResourceRecordType type) {
        this.owner = owner;
        this.classz = classz;
        this.type = type;
    }

    public static RRset createAs(ResourceRecord rr) {
        RRset rrset = new RRset(rr.getName(), rr.getClassz(), rr.getType());
        rrset.add(rr);
        return rrset;
    }

    public void add(ResourceRecord rr) {
        if (rr.getName() == null) {
            throw new IllegalArgumentException("Trying to add an Invalid rr to the rrset: " + rr);
        }
        if (rr.getClassz() != this.classz || rr.getType() != this.type || !rr.getName().equalsIgnoreCase(this.owner)) {
            throw new IllegalArgumentException("Trying to add an Invalid rr to the rrset: " + rr);
        }
        this.data.add(rr);
    }

    public void remove(ResourceRecord rr) {
        if (rr.getClassz() != this.classz || rr.getType() != this.type || !rr.getName().equalsIgnoreCase(this.owner)) {
            throw new IllegalArgumentException("Trying to remove an Invalid rr from the rrset: " + rr);
        }
        this.data.remove(rr);
    }

    public void clear() {
        this.data.clear();
    }

    public List<ResourceRecord> getAll() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RRset\n [ owner=" + this.owner + ", classz=" + this.classz + ", type=" + this.type + "\n");
        for (ResourceRecord rr : this.data) {
            b.append(rr.toString());
            b.append("\n");
        }
        b.append(" ]");
        return b.toString();
    }

    public Object toZone(int maxLength) {
        StringBuilder b = new StringBuilder();
        for (ResourceRecord rr : this.data) {
            b.append(rr.toZone(maxLength));
            b.append("\n");
        }
        return b.toString();
    }

    public JsonArray toJSon() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (ResourceRecord rr : this.data) {
            builder.add((JsonValue)rr.toJSon());
        }
        return builder.build();
    }

    public List<ResourceRecord> getData() {
        return this.data;
    }

    public String getOwner() {
        return this.owner;
    }

    public ResourceRecordClass getClassz() {
        return this.classz;
    }

    public ResourceRecordType getType() {
        return this.type;
    }

    public void setData(List<ResourceRecord> data) {
        this.data = data;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setClassz(ResourceRecordClass classz) {
        this.classz = classz;
    }

    public void setType(ResourceRecordType type) {
        this.type = type;
    }
}

