/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class AAAAResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private String address;
    private byte[] ipv6Bytes;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial && this.rdLength == '\u0010') {
            InetAddress ipv6Addres;
            this.ipv6Bytes = buffer.readBytes(16, 16);
            try {
                ipv6Addres = InetAddress.getByAddress(this.ipv6Bytes);
            }
            catch (UnknownHostException e) {
                throw new DnsDecodeException("Illegal ipv6 address", e);
            }
            this.setAddress(InetAddresses.toAddrString((InetAddress)ipv6Addres));
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.ipv6Bytes);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.address;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("address", this.address)).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AAAAResourceRecord other = (AAAAResourceRecord)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public String getAddress() {
        return this.address;
    }

    public byte[] getIpv6Bytes() {
        return this.ipv6Bytes;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setIpv6Bytes(byte[] ipv6Bytes) {
        this.ipv6Bytes = ipv6Bytes;
    }
}

