/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import org.apache.commons.codec.binary.Hex;

public class SSHFPResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private short algorithm;
    private short fingerprintType;
    private byte[] fingerprint;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.algorithm = buffer.readUnsignedByte();
            this.fingerprintType = buffer.readUnsignedByte();
            this.fingerprint = new byte[this.rdLength - 2];
            buffer.readBytes(this.fingerprint);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.rdata);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("algorithm", (int)this.algorithm).add("fptype", (int)this.fingerprintType).add("fingerprint", Hex.encodeHexString((byte[])this.fingerprint))).build();
    }

    public short getAlgorithm() {
        return this.algorithm;
    }

    public short getFingerprintType() {
        return this.fingerprintType;
    }

    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    public void setAlgorithm(short algorithm) {
        this.algorithm = algorithm;
    }

    public void setFingerprintType(short fingerprintType) {
        this.fingerprintType = fingerprintType;
    }

    public void setFingerprint(byte[] fingerprint) {
        this.fingerprint = fingerprint;
    }
}

