/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class URIResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1023178649874976277L;
    private int priority;
    private int weight;
    private String uri;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.priority = buffer.readUnsignedChar();
            this.weight = buffer.readUnsignedChar();
            byte[] uriBytes = new byte[this.rdLength - 4];
            buffer.readBytes(uriBytes);
            this.uri = new String(uriBytes);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.priority);
        buffer.writeChar(this.weight);
        buffer.writeBytes(this.uri.getBytes());
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.priority + " " + this.weight + " " + this.uri;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("priority", this.priority).add("weight", this.weight).add("uri", this.uri)).build();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getUri() {
        return this.uri;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

