/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.AlgorithmType;
import nl.sidnlabs.dnslib.types.DigestType;
import org.apache.commons.codec.binary.Hex;

public class DSResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private char keytag;
    private AlgorithmType algorithm;
    private DigestType digestType;
    private byte[] digest;
    private String hex;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.keytag = buffer.readUnsignedChar();
            short alg = buffer.readUnsignedByte();
            this.algorithm = AlgorithmType.fromValue(alg);
            short dt = buffer.readUnsignedByte();
            this.digestType = DigestType.fromValue(dt);
            this.digest = new byte[this.rdLength - 4];
            buffer.readBytes(this.digest);
            this.hex = new String(Hex.encodeHex((byte[])this.digest));
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.keytag);
        buffer.writeByte(this.algorithm.getValue());
        buffer.writeByte(this.digestType.getValue());
        buffer.writeBytes(this.digest);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("keytag", (int)this.keytag).add("algorithm", this.algorithm != null ? this.algorithm.name() : "").add("digest-type", this.digestType.name()).add("digest", this.hex)).build();
    }

    public char getKeytag() {
        return this.keytag;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String getHex() {
        return this.hex;
    }

    public void setKeytag(char keytag) {
        this.keytag = keytag;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public void setDigestType(DigestType digestType) {
        this.digestType = digestType;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }
}

