/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.NSECTypeDecoder;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.DigestType;
import nl.sidnlabs.dnslib.types.TypeMap;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;

public class NSEC3ResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private DigestType hashAlgorithm;
    private short flags;
    private char iterations;
    private short saltLength;
    private byte[] salt;
    private short hashLength;
    private String nexthashedownername;
    protected List<TypeMap> types = new ArrayList<TypeMap>();
    private boolean optout;
    private static final int RDATA_FIXED_FIELDS_LENGTH = 6;
    private static final byte FLAG_OPTOUT_MASK = 1;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            short ha = buffer.readUnsignedByte();
            this.hashAlgorithm = DigestType.fromValue(ha);
            this.flags = buffer.readUnsignedByte();
            this.optout = (this.flags & 1) == 1;
            this.iterations = buffer.readUnsignedChar();
            this.saltLength = buffer.readUnsignedByte();
            this.salt = new byte[this.saltLength];
            if (this.saltLength > 0) {
                buffer.readBytes(this.salt);
            }
            this.hashLength = buffer.readUnsignedByte();
            byte[] hash = new byte[this.hashLength];
            if (this.hashLength > 0) {
                buffer.readBytes(hash);
            }
            Base32 b32 = new Base32(true);
            this.nexthashedownername = b32.encodeAsString(hash);
            int octetAvailable = this.rdLength - (6 + this.saltLength + this.hashLength);
            new NSECTypeDecoder().decode(octetAvailable, buffer, this.types);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.rdata);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        builder.add("rdata", Json.createObjectBuilder().add("hash-algorithm", this.hashAlgorithm.name()).add("flags", (int)this.flags).add("iterations", (int)this.iterations).add("salt-length", (int)this.saltLength).add("salt", Hex.encodeHexString((byte[])this.salt)).add("hash-length", (int)this.hashLength).add("nxt-own-name", this.nexthashedownername));
        JsonArrayBuilder typeBuilder = Json.createArrayBuilder();
        for (TypeMap type : this.types) {
            typeBuilder.add(type.getType().name());
        }
        return builder.add("types", (JsonValue)typeBuilder.build()).build();
    }

    @Override
    public String toZone(int maxLength) {
        StringBuilder b = new StringBuilder();
        b.append(super.toZone(maxLength) + "\t" + this.hashAlgorithm.getValue() + " " + this.flags + " " + this.iterations + " ");
        if (this.saltLength == 0) {
            b.append("- ");
        } else {
            b.append(Hex.encodeHexString((byte[])this.salt) + " ");
        }
        b.append(this.nexthashedownername + " ");
        for (TypeMap type : this.types) {
            b.append(type.name() + " ");
        }
        return b.toString();
    }

    public DigestType getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public short getFlags() {
        return this.flags;
    }

    public char getIterations() {
        return this.iterations;
    }

    public short getSaltLength() {
        return this.saltLength;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public short getHashLength() {
        return this.hashLength;
    }

    public String getNexthashedownername() {
        return this.nexthashedownername;
    }

    public List<TypeMap> getTypes() {
        return this.types;
    }

    public boolean isOptout() {
        return this.optout;
    }

    public void setHashAlgorithm(DigestType hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void setIterations(char iterations) {
        this.iterations = iterations;
    }

    public void setSaltLength(short saltLength) {
        this.saltLength = saltLength;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public void setHashLength(short hashLength) {
        this.hashLength = hashLength;
    }

    public void setNexthashedownername(String nexthashedownername) {
        this.nexthashedownername = nexthashedownername;
    }

    public void setTypes(List<TypeMap> types) {
        this.types = types;
    }

    public void setOptout(boolean optout) {
        this.optout = optout;
    }
}

