/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.sidnlabs.dnslib.util.RegisteredDomain;
import org.apache.commons.lang3.StringUtils;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;

public class DomainName {
    private static final Map<String, Rules> cache = new ConcurrentHashMap<String, Rules>();
    private static final int CACHE_MAX_SIZE = 5000;
    private static final Cache<String, RegisteredDomain> notfoundCache = new Cache2kBuilder<String, RegisteredDomain>(){}.entryCapacity(5000L).build();

    private DomainName() {
    }

    public static RegisteredDomain registeredDomain(String domain) {
        Match match;
        String lastLabel = StringUtils.substringAfterLast((String)domain, (String)".");
        if (StringUtils.isNotBlank((CharSequence)lastLabel)) {
            RegisteredDomain hit = (RegisteredDomain)notfoundCache.peek((Object)lastLabel);
            if (hit != null) {
                return hit;
            }
        } else {
            lastLabel = domain;
        }
        if ((match = DomainName.getMatch(domain, lastLabel)) != null) {
            return match.registeredDomain();
        }
        return (RegisteredDomain)notfoundCache.peek((Object)lastLabel);
    }

    private static Match getMatch(String domain, String lastLabel) {
        if (domain == null) {
            throw new NullPointerException();
        }
        Rules rules = Rules.getRules(domain, lastLabel);
        return rules == null ? null : rules.match(domain);
    }

    private static interface Match {
        public RegisteredDomain registeredDomain();

        public Rule.Type type();
    }

    private static class Rules {
        private final LinkedList<RuleSet> ruleSets = new LinkedList();
        private final boolean hasExceptions;

        private Rules(InputStream is) throws IOException {
            String line;
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            boolean hasExceptions = false;
            int type = reader.read();
            while (type != -1 && (line = reader.readLine()) != null) {
                int numLabels = RuleSet.numLabels(line);
                if (numLabels != 0) {
                    RuleSet ruleset = this.getRuleSet(numLabels - 1);
                    ruleset.addRule(type, line);
                    hasExceptions |= ruleset.hasExceptions;
                }
                type = reader.read();
            }
            this.hasExceptions = hasExceptions;
        }

        static Rules getRules(String domain, String lastLabel) {
            String tld = Rules.getTopLevelDomain(domain);
            if (tld.isEmpty()) {
                return null;
            }
            return cache.computeIfAbsent(tld, k -> Rules.createRules(tld, lastLabel));
        }

        private static String getTopLevelDomain(String domain) {
            int n = domain.lastIndexOf(46);
            if (n == -1) {
                return domain;
            }
            return domain.substring(n + 1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Rules createRules(String tld, String lastLabel) {
            try (InputStream pubSuffixStream = Rules.getPubSuffixStream();){
                if (pubSuffixStream == null) {
                    Rules rules2 = null;
                    return rules2;
                }
                Rules rules = Rules.getRules(tld, new ZipInputStream(pubSuffixStream), lastLabel);
                return rules;
            }
            catch (IOException e) {
                return null;
            }
        }

        private static InputStream getPubSuffixStream() {
            InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    File f = new File(System.getProperty("java.home"), "lib/security/public_suffix_list.dat");
                    try {
                        return new FileInputStream(f);
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
            });
            if (is == null) {
                // empty if block
            }
            return is;
        }

        private static Rules getRules(String tld, ZipInputStream zis, String lastLabel) throws IOException {
            boolean found = false;
            ZipEntry ze = zis.getNextEntry();
            while (ze != null && !found) {
                if (ze.getName().equals(tld)) {
                    found = true;
                    continue;
                }
                ze = zis.getNextEntry();
            }
            if (!found) {
                RegisteredDomainImpl d = new RegisteredDomainImpl(lastLabel, RegisteredDomain.Type.PRIVATE, lastLabel);
                notfoundCache.put((Object)lastLabel, (Object)d);
                return null;
            }
            return new Rules(zis);
        }

        private RuleSet getRuleSet(int index) {
            if (index < this.ruleSets.size()) {
                return this.ruleSets.get(index);
            }
            RuleSet r = null;
            for (int i = this.ruleSets.size(); i <= index; ++i) {
                r = new RuleSet(i + 1);
                this.ruleSets.add(r);
            }
            return r;
        }

        Match match(String domain) {
            Match possibleMatch = null;
            Iterator<RuleSet> it = this.ruleSets.descendingIterator();
            while (it.hasNext()) {
                RuleSet ruleSet = it.next();
                Match match = ruleSet.match(domain);
                if (match == null) continue;
                if (match.type() == Rule.Type.EXCEPTION || !this.hasExceptions) {
                    return match;
                }
                if (possibleMatch != null) continue;
                possibleMatch = match;
            }
            return possibleMatch;
        }

        private static class RuleSet {
            private final int numLabels;
            private final Set<Rule> rules = new HashSet<Rule>();
            boolean hasExceptions = false;
            private static final RegisteredDomain.Type[] AUTHS = RegisteredDomain.Type.values();

            RuleSet(int n) {
                this.numLabels = n;
            }

            void addRule(int auth, String rule) {
                if (rule.startsWith("!")) {
                    this.rules.add(new Rule(rule.substring(1), Rule.Type.EXCEPTION, AUTHS[auth]));
                    this.hasExceptions = true;
                } else if (rule.startsWith("*.") && rule.lastIndexOf(42) == 0) {
                    this.rules.add(new Rule(rule.substring(2), Rule.Type.WILDCARD, AUTHS[auth]));
                } else if (rule.indexOf(42) == -1) {
                    this.rules.add(new Rule(rule, Rule.Type.NORMAL, AUTHS[auth]));
                } else {
                    this.rules.add(new OtherRule(rule, AUTHS[auth], RuleSet.split(rule)));
                }
            }

            Match match(String domain) {
                Match match = null;
                for (Rule rule : this.rules) {
                    switch (rule.type) {
                        case NORMAL: {
                            if (match != null) break;
                            match = this.matchNormal(domain, rule);
                            break;
                        }
                        case WILDCARD: {
                            if (match != null) break;
                            match = this.matchWildcard(domain, rule);
                            break;
                        }
                        case OTHER: {
                            if (match != null) break;
                            match = this.matchOther(domain, rule);
                            break;
                        }
                        case EXCEPTION: {
                            Match excMatch = this.matchException(domain, rule);
                            if (excMatch == null) break;
                            return excMatch;
                        }
                    }
                }
                return match;
            }

            private static LinkedList<String> split(String rule) {
                String[] labels = rule.split("\\.");
                return new LinkedList<String>(Arrays.asList(labels));
            }

            private static int numLabels(String rule) {
                if (rule.equals("")) {
                    return 0;
                }
                int len = rule.length();
                int count = 0;
                int index = 0;
                while (index < len) {
                    int pos = rule.indexOf(46, index);
                    if (pos == -1) {
                        return count + 1;
                    }
                    index = pos + 1;
                    ++count;
                }
                return count;
            }

            private Match matchNormal(String domain, Rule rule) {
                int index = RuleSet.labels(domain, this.numLabels);
                if (index == -1) {
                    return null;
                }
                String substring = domain.substring(index);
                if (rule.domain.equals(substring)) {
                    return new CommonMatch(domain, rule, index);
                }
                return null;
            }

            private Match matchWildcard(String domain, Rule rule) {
                String substring;
                int index = RuleSet.labels(domain, this.numLabels - 1);
                if (index > 0 && rule.domain.equals(substring = domain.substring(index))) {
                    return new CommonMatch(domain, rule, RuleSet.labels(domain, this.numLabels));
                }
                return null;
            }

            private Match matchException(String domain, Rule rule) {
                int index = RuleSet.labels(domain, this.numLabels);
                if (index == -1) {
                    return null;
                }
                String substring = domain.substring(index);
                if (rule.domain.equals(substring)) {
                    return new CommonMatch(domain, rule, RuleSet.labels(domain, this.numLabels - 1));
                }
                return null;
            }

            private Match matchOther(String domain, Rule rule) {
                OtherRule otherRule = (OtherRule)rule;
                LinkedList<String> target = RuleSet.split(domain);
                int diff = target.size() - this.numLabels;
                if (diff < 0) {
                    return null;
                }
                boolean found = true;
                for (int i = 0; i < this.numLabels; ++i) {
                    String ruleLabel = otherRule.labels.get(i);
                    String targetLabel = target.get(i + diff);
                    if (ruleLabel.charAt(0) == '*' || ruleLabel.equalsIgnoreCase(targetLabel)) continue;
                    found = false;
                    break;
                }
                if (found) {
                    return new OtherMatch(rule, this.numLabels, target);
                }
                return null;
            }

            private static int labels(String s, int n) {
                if (n < 1) {
                    return -1;
                }
                int index = s.length();
                for (int i = 0; i < n; ++i) {
                    int next = s.lastIndexOf(46, index);
                    if (next == -1) {
                        if (i == n - 1) {
                            return 0;
                        }
                        return -1;
                    }
                    index = next - 1;
                }
                return index + 2;
            }
        }
    }

    private static class OtherMatch
    implements Match {
        private final Rule rule;
        private final int numLabels;
        private final LinkedList<String> target;

        OtherMatch(Rule rule, int numLabels, LinkedList<String> target) {
            this.rule = rule;
            this.numLabels = numLabels;
            this.target = target;
        }

        @Override
        public RegisteredDomain registeredDomain() {
            int nlabels = this.numLabels + 1;
            if (nlabels > this.target.size()) {
                return null;
            }
            return new RegisteredDomainImpl(this.getSuffixes(nlabels), this.rule.auth, this.getSuffixes(this.numLabels));
        }

        @Override
        public Rule.Type type() {
            return this.rule.type;
        }

        private String getSuffixes(int n) {
            Iterator<String> targetIter = this.target.descendingIterator();
            StringBuilder sb = new StringBuilder();
            while (n > 0 && targetIter.hasNext()) {
                String s = targetIter.next();
                sb.insert(0, s);
                if (n > 1) {
                    sb.insert(0, '.');
                }
                --n;
            }
            return sb.toString();
        }
    }

    private static class CommonMatch
    implements Match {
        private String domain;
        private int publicSuffix;
        private int registeredDomain;
        private final Rule rule;

        CommonMatch(String domain, Rule rule, int publicSuffix) {
            this.domain = domain;
            this.publicSuffix = publicSuffix;
            this.rule = rule;
            this.registeredDomain = domain.lastIndexOf(46, publicSuffix - 2);
            this.registeredDomain = this.registeredDomain == -1 ? 0 : ++this.registeredDomain;
        }

        @Override
        public RegisteredDomain registeredDomain() {
            if (this.publicSuffix == 0) {
                return null;
            }
            return new RegisteredDomainImpl(this.domain.substring(this.registeredDomain), this.rule.auth, this.domain.substring(this.publicSuffix));
        }

        @Override
        public Rule.Type type() {
            return this.rule.type;
        }
    }

    private static class RegisteredDomainImpl
    implements RegisteredDomain {
        private final String name;
        private final RegisteredDomain.Type type;
        private final String publicSuffix;

        RegisteredDomainImpl(String name, RegisteredDomain.Type type, String publicSuffix) {
            this.name = name;
            this.type = type;
            this.publicSuffix = publicSuffix;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public RegisteredDomain.Type type() {
            return this.type;
        }

        @Override
        public String publicSuffix() {
            return this.publicSuffix;
        }
    }

    private static class OtherRule
    extends Rule {
        List<String> labels;

        OtherRule(String domain, RegisteredDomain.Type auth, List<String> labels) {
            super(domain, Rule.Type.OTHER, auth);
            this.labels = labels;
        }
    }

    private static class Rule {
        String domain;
        Type type;
        RegisteredDomain.Type auth;

        Rule(String domain, Type type, RegisteredDomain.Type auth) {
            this.domain = domain;
            this.type = type;
            this.auth = auth;
        }

        static enum Type {
            EXCEPTION,
            NORMAL,
            OTHER,
            WILDCARD;

        }
    }
}

