/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import nl.sidnlabs.dnslib.util.DomainName;
import nl.sidnlabs.dnslib.util.RegisteredDomain;
import org.apache.commons.lang3.StringUtils;

public class NameUtil {
    private NameUtil() {
    }

    public static String domainname(String qname) {
        if (qname == null) {
            return null;
        }
        int len = qname.length();
        if (len >= 4 && qname.charAt(len - 4) == '.' && qname.charAt(len - 3) == 'n' && qname.charAt(len - 2) == 'l' && qname.charAt(len - 1) == '.') {
            String[] parts = StringUtils.split((String)qname, (char)'.');
            if (parts != null && parts.length >= 2) {
                return parts[parts.length - 2] + "." + parts[parts.length - 1];
            }
            return null;
        }
        if (qname.length() > 2) {
            RegisteredDomain d;
            if (qname.endsWith(".")) {
                qname = qname.substring(0, qname.length() - 1);
            }
            if ((d = DomainName.registeredDomain(qname)) != null) {
                return d.name();
            }
        }
        return null;
    }

    public static int labels(String qname) {
        if (qname == null || qname.length() == 0 || qname.length() == 1 && qname.charAt(0) == '.') {
            return 0;
        }
        if (qname.charAt(0) == '.') {
            return StringUtils.countMatches((CharSequence)qname, (char)'.') - 1;
        }
        return StringUtils.countMatches((CharSequence)qname, (char)'.');
    }
}

