/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class AResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = -1960441085310394001L;
    private String address;
    private int[] ipv4Bytes;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial && this.rdLength == '\u0004') {
            InetAddress ip;
            byte[] addrBytes = buffer.readBytes(4, 4);
            try {
                ip = InetAddress.getByAddress(addrBytes);
            }
            catch (UnknownHostException e) {
                throw new DnsDecodeException("Invalid IP address", e);
            }
            this.setAddress(ip.getHostAddress());
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        if (this.ipv4Bytes != null && this.ipv4Bytes.length == 4) {
            for (int i = 0; i < 4; ++i) {
                buffer.writeByte(this.ipv4Bytes[i]);
            }
        }
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.address;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("address", this.address)).build();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AResourceRecord other = (AResourceRecord)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public String getAddress() {
        return this.address;
    }

    public int[] getIpv4Bytes() {
        return this.ipv4Bytes;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setIpv4Bytes(int[] ipv4Bytes) {
        this.ipv4Bytes = ipv4Bytes;
    }
}

