/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class PTRResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6138339087534370002L;
    private String ptrDname;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.ptrDname = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.ptrDname.length() + 2);
        DNSStringUtil.writeName(this.ptrDname, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.ptrDname;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("ptrdname", this.ptrDname)).build();
    }

    public String getPtrDname() {
        return this.ptrDname;
    }

    public void setPtrDname(String ptrDname) {
        this.ptrDname = ptrDname;
    }
}

