/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class SRVResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private char priority;
    private char weight;
    private char port;
    private String target;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.priority = buffer.readUnsignedChar();
            this.weight = buffer.readUnsignedChar();
            this.port = buffer.readUnsignedChar();
            this.target = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(6 + this.target.length() + 2);
        buffer.writeChar(this.priority);
        buffer.writeChar(this.weight);
        buffer.writeChar(this.port);
        DNSStringUtil.writeName(this.target, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.priority + " " + this.weight + " " + this.port + " " + this.target;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("priority", (int)this.priority)).add("weight", (int)this.weight).add("port", (int)this.port).add("target", this.target).build();
    }

    public char getPriority() {
        return this.priority;
    }

    public char getWeight() {
        return this.weight;
    }

    public char getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    public void setPriority(char priority) {
        this.priority = priority;
    }

    public void setWeight(char weight) {
        this.weight = weight;
    }

    public void setPort(char port) {
        this.port = port;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

