/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import com.google.common.net.InternetDomainName;
import org.apache.commons.lang3.StringUtils;

public class NameUtil {
    private NameUtil() {
    }

    public static boolean isValid(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*') continue;
            return false;
        }
        return true;
    }

    public static String domainname(String qname) {
        if (qname == null) {
            return null;
        }
        int len = qname.length();
        if (len >= 4 && qname.charAt(len - 4) == '.' && qname.charAt(len - 3) == 'n' && qname.charAt(len - 2) == 'l' && qname.charAt(len - 1) == '.') {
            String[] parts = StringUtils.split((String)qname, (char)'.');
            if (parts != null && parts.length >= 2 && !StringUtils.equalsIgnoreCase((CharSequence)parts[parts.length - 2], (CharSequence)"*")) {
                return parts[parts.length - 2] + "." + parts[parts.length - 1];
            }
            return null;
        }
        if (qname.length() > 2) {
            if ((qname = StringUtils.remove((String)qname, (String)"_")).endsWith(".")) {
                qname = StringUtils.strip((String)qname, (String)".");
            }
            try {
                InternetDomainName d = InternetDomainName.from((String)qname);
                return d.topDomainUnderRegistrySuffix().toString();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static int labels(String qname) {
        if (qname == null || qname.length() == 0 || qname.length() == 1 && qname.charAt(0) == '.') {
            return 0;
        }
        if (qname.charAt(0) == '.') {
            return StringUtils.countMatches((CharSequence)qname, (char)'.') - 1;
        }
        return StringUtils.countMatches((CharSequence)qname, (char)'.');
    }
}

