/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.io.Serializable;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.ResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.ResourceRecordClass;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractResourceRecord
implements ResourceRecord,
Serializable {
    private static final long serialVersionUID = -2781381098732827757L;
    protected String name;
    protected char rawType;
    protected char rawClassz;
    protected ResourceRecordType type;
    protected ResourceRecordClass classz;
    protected long ttl;
    protected char rdLength;
    protected byte[] rdata;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        this.setName(DNSStringUtil.readNameUsingBuffer(buffer));
        this.rawType = buffer.readUnsignedChar();
        this.setType(ResourceRecordType.fromValue(this.rawType));
        this.rawClassz = buffer.readUnsignedChar();
        this.setClassz(ResourceRecordClass.fromValue(this.rawClassz));
        this.setTtl(buffer.readUnsignedInt());
        this.rdLength = buffer.readUnsignedChar();
        if (partial) {
            buffer.setReaderIndex(buffer.getReaderIndex() + this.rdLength);
        } else if (this.rdLength <= buffer.bytesAvailable()) {
            buffer.markReaderIndex();
            this.rdata = new byte[this.rdLength];
            buffer.readBytes(this.rdata);
            buffer.resetReaderIndex();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        DNSStringUtil.writeName(this.getName(), buffer);
        buffer.writeChar(this.getType().getValue());
        buffer.writeChar(this.getClassz().getValue());
        buffer.writeInt((int)this.getTtl());
    }

    public int getRawType() {
        return this.rawType;
    }

    public int getRawClassz() {
        return this.rawClassz;
    }

    @Override
    public String toZone(int maxLength) {
        int paddedSize = maxLength - this.name.length() + this.name.length();
        String ownerWithPadding = StringUtils.rightPad((String)this.name, (int)paddedSize, (String)" ");
        return ownerWithPadding + "\t" + this.ttl + "\t" + String.valueOf((Object)this.classz) + "\t" + String.valueOf((Object)this.type);
    }

    public JsonObjectBuilder createJsonBuilder() {
        return Json.createObjectBuilder().add("name", this.name).add("type", this.type.name()).add("class", this.classz.name()).add("ttl", this.ttl).add("rdLength", (int)this.rdLength);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = this.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("dummy", "toddo")).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractResourceRecord other = (AbstractResourceRecord)obj;
        if (this.classz != other.classz) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.rdLength != other.rdLength) {
            return false;
        }
        if (this.ttl != other.ttl) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classz == null ? 0 : this.classz.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.rdLength;
        result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public String rDataToString() {
        return null;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public ResourceRecordType getType() {
        return this.type;
    }

    @Override
    @Generated
    public ResourceRecordClass getClassz() {
        return this.classz;
    }

    @Override
    @Generated
    public long getTtl() {
        return this.ttl;
    }

    @Override
    @Generated
    public char getRdLength() {
        return this.rdLength;
    }

    @Override
    @Generated
    public byte[] getRdata() {
        return this.rdata;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRawType(char rawType) {
        this.rawType = rawType;
    }

    @Generated
    public void setRawClassz(char rawClassz) {
        this.rawClassz = rawClassz;
    }

    @Override
    @Generated
    public void setType(ResourceRecordType type) {
        this.type = type;
    }

    @Override
    @Generated
    public void setClassz(ResourceRecordClass classz) {
        this.classz = classz;
    }

    @Override
    @Generated
    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    @Generated
    public void setRdLength(char rdLength) {
        this.rdLength = rdLength;
    }

    @Generated
    public void setRdata(byte[] rdata) {
        this.rdata = rdata;
    }
}

