/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class CNAMEResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = -1067442440297409161L;
    private String cname;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.cname = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.cname.length() + 2);
        DNSStringUtil.writeName(this.cname, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.cname;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("cname", this.cname)).build();
    }

    @Override
    public String rDataToString() {
        return this.cname;
    }

    @Generated
    public String getCname() {
        return this.cname;
    }

    @Generated
    public void setCname(String cname) {
        this.cname = cname;
    }
}

