/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class HINFOResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 5246353495397154374L;
    private String cpu;
    private String os;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.cpu = DNSStringUtil.readNameUsingBuffer(buffer);
            this.os = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.cpu.length() + this.os.length() + 4);
        DNSStringUtil.writeName(this.cpu, buffer);
        DNSStringUtil.writeName(this.os, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.cpu + " " + this.os;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("cpu", this.cpu).add("os", this.os)).build();
    }

    @Override
    public String rDataToString() {
        return this.cpu + "," + this.os;
    }

    @Generated
    public String getCpu() {
        return this.cpu;
    }

    @Generated
    public String getOs() {
        return this.os;
    }

    @Generated
    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setOs(String os) {
        this.os = os;
    }
}

