/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import lombok.Generated;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class LOCResourceRecord
extends AbstractResourceRecord {
    private static NumberFormat w2 = new DecimalFormat();
    private static NumberFormat w3;
    private static final long serialVersionUID = 1L;
    private short version;
    private short size;
    private short sizeBase;
    private short sizePower;
    private short horizontalPrecision;
    private short verticalPrecision;
    private long latitude;
    private long longitude;
    private long altitude;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.version = buffer.readUnsignedByte();
            if (this.version != 0) {
                throw new DnsDecodeException("LOCResourceRecord Illegal version number: " + this.version);
            }
            this.size = buffer.readUnsignedByte();
            this.sizeBase = (short)((this.size & 0xF0) >>> 4);
            this.sizePower = (short)(this.size & 0xF);
            this.horizontalPrecision = buffer.readUnsignedByte();
            this.verticalPrecision = buffer.readUnsignedByte();
            this.latitude = buffer.readUnsignedInt();
            this.longitude = buffer.readUnsignedInt();
            this.altitude = buffer.readUnsignedInt();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeByte(this.version);
        buffer.writeByte(this.size);
        buffer.writeByte(this.horizontalPrecision);
        buffer.writeByte(this.verticalPrecision);
        buffer.writeInt(this.latitude);
        buffer.writeInt(this.longitude);
        buffer.writeInt(this.altitude);
    }

    @Override
    public String toZone(int maxLength) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toZone(maxLength) + "\t");
        sb.append(this.positionToString(this.latitude, 'N', 'S'));
        sb.append(" ");
        sb.append(this.positionToString(this.longitude, 'E', 'W'));
        sb.append(" ");
        this.renderFixedPoint(sb, w2, this.altitude - 10000000L, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.size, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.horizontalPrecision, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.verticalPrecision, 100L);
        sb.append("m");
        return sb.toString();
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("version", (int)this.version).add("size", (int)this.size).add("hor_pre", (int)this.horizontalPrecision).add("vert_pre", (int)this.verticalPrecision).add("lat", this.latitude).add("long", this.longitude).add("alt", this.altitude)).build();
    }

    private String positionToString(long value, char pos, char neg) {
        char direction;
        StringBuilder sb = new StringBuilder();
        long temp = value - 0x80000000L;
        if (temp < 0L) {
            temp = -temp;
            direction = neg;
        } else {
            direction = pos;
        }
        sb.append(temp / 3600000L);
        sb.append(" ");
        sb.append((temp %= 3600000L) / 60000L);
        sb.append(" ");
        this.renderFixedPoint(sb, w3, temp %= 60000L, 1000L);
        sb.append(" ");
        sb.append(direction);
        return sb.toString();
    }

    private void renderFixedPoint(StringBuilder sb, NumberFormat formatter, long value, long divisor) {
        sb.append(value / divisor);
        if ((value %= divisor) != 0L) {
            sb.append(".");
            sb.append(formatter.format(value));
        }
    }

    @Override
    public String rDataToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.positionToString(this.latitude, 'N', 'S'));
        sb.append(",");
        sb.append(this.positionToString(this.longitude, 'E', 'W'));
        sb.append(",");
        this.renderFixedPoint(sb, w2, this.altitude - 10000000L, 100L);
        sb.append("m,");
        this.renderFixedPoint(sb, w2, this.size, 100L);
        sb.append("m,");
        this.renderFixedPoint(sb, w2, this.horizontalPrecision, 100L);
        sb.append("m,");
        this.renderFixedPoint(sb, w2, this.verticalPrecision, 100L);
        sb.append("m");
        return sb.toString();
    }

    @Generated
    public short getVersion() {
        return this.version;
    }

    @Generated
    public short getSize() {
        return this.size;
    }

    @Generated
    public short getSizeBase() {
        return this.sizeBase;
    }

    @Generated
    public short getSizePower() {
        return this.sizePower;
    }

    @Generated
    public short getHorizontalPrecision() {
        return this.horizontalPrecision;
    }

    @Generated
    public short getVerticalPrecision() {
        return this.verticalPrecision;
    }

    @Generated
    public long getLatitude() {
        return this.latitude;
    }

    @Generated
    public long getLongitude() {
        return this.longitude;
    }

    @Generated
    public long getAltitude() {
        return this.altitude;
    }

    @Generated
    public void setVersion(short version) {
        this.version = version;
    }

    @Generated
    public void setSize(short size) {
        this.size = size;
    }

    @Generated
    public void setSizeBase(short sizeBase) {
        this.sizeBase = sizeBase;
    }

    @Generated
    public void setSizePower(short sizePower) {
        this.sizePower = sizePower;
    }

    @Generated
    public void setHorizontalPrecision(short horizontalPrecision) {
        this.horizontalPrecision = horizontalPrecision;
    }

    @Generated
    public void setVerticalPrecision(short verticalPrecision) {
        this.verticalPrecision = verticalPrecision;
    }

    @Generated
    public void setLatitude(long latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(long longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setAltitude(long altitude) {
        this.altitude = altitude;
    }

    static {
        w2.setMinimumIntegerDigits(2);
        w3 = new DecimalFormat();
        w3.setMinimumIntegerDigits(3);
    }
}

