/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class MXResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6877262886026363052L;
    private char preference;
    private String exchange;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.preference = buffer.readUnsignedChar();
            this.exchange = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.exchange.length() + 2 + 2);
        buffer.writeChar(this.preference);
        DNSStringUtil.writeName(this.exchange, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.preference + " " + this.exchange;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("preference", (int)this.preference).add("exchange", this.exchange)).build();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exchange == null ? 0 : this.exchange.hashCode());
        result = 31 * result + this.preference;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MXResourceRecord other = (MXResourceRecord)obj;
        if (this.exchange == null ? other.exchange != null : !this.exchange.equals(other.exchange)) {
            return false;
        }
        return this.preference == other.preference;
    }

    @Override
    public String rDataToString() {
        return this.preference + "," + this.exchange;
    }

    @Generated
    public char getPreference() {
        return this.preference;
    }

    @Generated
    public String getExchange() {
        return this.exchange;
    }

    @Generated
    public void setPreference(char preference) {
        this.preference = preference;
    }

    @Generated
    public void setExchange(String exchange) {
        this.exchange = exchange;
    }
}

