/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class NAPTRResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6981260851592320670L;
    private char order;
    private char preference;
    private String flags;
    private String services;
    private String regexp;
    private String replacement;
    private int length;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.order = buffer.readUnsignedChar();
            this.preference = buffer.readUnsignedChar();
            this.flags = DNSStringUtil.readLabelData(buffer);
            this.length = 5 + this.flags.length();
            this.services = DNSStringUtil.readLabelData(buffer);
            this.length = this.length + this.services.length() + 1;
            this.regexp = DNSStringUtil.readLabelData(buffer);
            this.length = this.length + this.regexp.length() + 1;
            this.replacement = DNSStringUtil.readNameUsingBuffer(buffer);
            this.length = this.replacement == null || this.replacement.length() == 0 ? ++this.length : this.length + this.replacement.length() + 1;
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.length);
        buffer.writeChar(this.preference);
        DNSStringUtil.writeLabelData(this.flags, buffer);
        DNSStringUtil.writeLabelData(this.services, buffer);
        DNSStringUtil.writeLabelData(this.regexp, buffer);
        DNSStringUtil.writeName(this.replacement, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.order + " " + this.preference + " \"" + this.flags + "\" \"" + this.services + "\" \"" + this.regexp + "\" " + this.replacement;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("order", (int)this.order).add("preference", (int)this.preference).add("flags", this.flags).add("services", this.services).add("regexp", this.regexp).add("replacement", this.replacement).add("length", this.length)).build();
    }

    @Generated
    public char getOrder() {
        return this.order;
    }

    @Generated
    public char getPreference() {
        return this.preference;
    }

    @Generated
    public String getFlags() {
        return this.flags;
    }

    @Generated
    public String getServices() {
        return this.services;
    }

    @Generated
    public String getRegexp() {
        return this.regexp;
    }

    @Generated
    public String getReplacement() {
        return this.replacement;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public void setOrder(char order) {
        this.order = order;
    }

    @Generated
    public void setPreference(char preference) {
        this.preference = preference;
    }

    @Generated
    public void setFlags(String flags) {
        this.flags = flags;
    }

    @Generated
    public void setServices(String services) {
        this.services = services;
    }

    @Generated
    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    @Generated
    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Generated
    public void setLength(int length) {
        this.length = length;
    }
}

