/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotImplementedResourceRecord
extends AbstractResourceRecord {
    @Generated
    private static final Logger log = LogManager.getLogger(NotImplementedResourceRecord.class);
    private static final long serialVersionUID = -6965650782859969009L;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (log.isDebugEnabled()) {
            log.debug("Decode unknown RR with name: " + this.getName());
            log.debug("Unknown RR has size: " + this.rdLength);
            log.debug(this.toZone(100));
        }
        if (!partial && this.rdLength > '\u0000') {
            buffer.setReaderIndex(buffer.getReaderIndex() + this.rdLength);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.rdata);
    }

    @Override
    public String toZone(int maxLength) {
        StringBuilder b = new StringBuilder();
        int paddedSize = maxLength - this.name.length() + this.name.length();
        String ownerWithPadding = StringUtils.rightPad((String)this.name, (int)paddedSize, (String)" ");
        b.append(ownerWithPadding + "\t" + this.ttl + "\t");
        if (this.classz == null) {
            b.append("CLASS" + this.rawClassz);
        } else {
            b.append((Object)this.classz);
        }
        b.append("\t");
        if (this.type == null) {
            b.append("TYPE" + this.rawType);
        } else {
            b.append((Object)this.type);
        }
        b.append("\t");
        b.append("\\# " + this.rdLength);
        if (this.rdLength > '\u0000') {
            b.append(" " + Hex.encodeHexString((byte[])this.rdata));
        }
        return b.toString();
    }

    @Override
    public JsonObject toJSon() {
        Object actualClass = null;
        String actualType = null;
        actualClass = this.classz == null ? "CLASS" + this.rawClassz : this.classz.name();
        actualType = this.type == null ? "TYPE" + this.rawType : String.valueOf((Object)this.type);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("class", (String)actualClass).add("type", actualType).add("rdlength", (int)this.rdLength).add("rdata", Hex.encodeHexString((byte[])this.rdata))).build();
    }
}

