/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class PTRResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6138339087534370002L;
    private String ptrDname;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.ptrDname = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.ptrDname.length() + 2);
        DNSStringUtil.writeName(this.ptrDname, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.ptrDname;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("ptrdname", this.ptrDname)).build();
    }

    @Override
    public String rDataToString() {
        return this.ptrDname;
    }

    @Generated
    public String getPtrDname() {
        return this.ptrDname;
    }

    @Generated
    public void setPtrDname(String ptrDname) {
        this.ptrDname = ptrDname;
    }
}

