/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import org.apache.commons.codec.binary.Hex;

public class SSHFPResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private short algorithm;
    private short fingerprintType;
    private byte[] fingerprint;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.algorithm = buffer.readUnsignedByte();
            this.fingerprintType = buffer.readUnsignedByte();
            this.fingerprint = new byte[this.rdLength - 2];
            buffer.readBytes(this.fingerprint);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.rdata);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("algorithm", (int)this.algorithm).add("fptype", (int)this.fingerprintType).add("fingerprint", Hex.encodeHexString((byte[])this.fingerprint))).build();
    }

    @Generated
    public short getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public short getFingerprintType() {
        return this.fingerprintType;
    }

    @Generated
    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public void setAlgorithm(short algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setFingerprintType(short fingerprintType) {
        this.fingerprintType = fingerprintType;
    }

    @Generated
    public void setFingerprint(byte[] fingerprint) {
        this.fingerprint = fingerprint;
    }
}

