/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class URIResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1023178649874976277L;
    private int priority;
    private int weight;
    private String uri;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.priority = buffer.readUnsignedChar();
            this.weight = buffer.readUnsignedChar();
            byte[] uriBytes = new byte[this.rdLength - 4];
            buffer.readBytes(uriBytes);
            this.uri = new String(uriBytes);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.priority);
        buffer.writeChar(this.weight);
        buffer.writeBytes(this.uri.getBytes());
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.priority + " " + this.weight + " " + this.uri;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("priority", this.priority).add("weight", this.weight).add("uri", this.uri)).build();
    }

    @Override
    public String rDataToString() {
        return this.uri;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public int getWeight() {
        return this.weight;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }
}

