/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.security.PublicKey;
import lombok.Generated;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.AlgorithmType;
import nl.sidnlabs.dnslib.util.KeyUtil;
import org.apache.commons.codec.binary.Base64;

public class DNSKEYResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private char flags;
    private short protocol;
    private AlgorithmType algorithm;
    private PublicKey publicKey;
    private byte[] keydata;
    private int keytag;
    private boolean isZoneKey;
    private boolean isSepKey;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.flags = buffer.readUnsignedChar();
            this.protocol = buffer.readUnsignedByte();
            short alg = buffer.readUnsignedByte();
            this.algorithm = AlgorithmType.fromValue(alg);
            char keysize = (char)(this.rdLength - 4);
            this.keydata = new byte[keysize];
            buffer.readBytes(this.keydata);
            this.publicKey = KeyUtil.createPublicKey(this.keydata, alg);
            this.keytag = KeyUtil.createKeyTag(this.rdata, alg);
            this.isZoneKey = KeyUtil.isZoneKey(this);
            this.isSepKey = KeyUtil.isSepKey(this);
        }
    }

    public boolean isValid() {
        if (this.protocol != 3) {
            return false;
        }
        return this.flags == '\u0000' || this.flags == '\u0100' || this.flags == '\u0101';
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.flags);
        buffer.writeByte(this.protocol);
        buffer.writeByte(this.algorithm.getValue());
        buffer.writeBytes(this.keydata);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + " " + this.flags + " " + this.protocol + " " + this.algorithm.getValue() + "(\n\t\t\t\t\t\t" + new Base64(36, "\n\t\t\t\t\t\t".getBytes()).encodeAsString(this.keydata) + " )";
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("flags", (int)this.flags)).add("protocol", (int)this.protocol).add("algorithm", this.algorithm.name()).add("zone-key", this.isZoneKey).add("sep-key", this.isSepKey).add("keytag", this.keytag).build();
    }

    @Generated
    public char getFlags() {
        return this.flags;
    }

    @Generated
    public short getProtocol() {
        return this.protocol;
    }

    @Generated
    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public byte[] getKeydata() {
        return this.keydata;
    }

    @Generated
    public int getKeytag() {
        return this.keytag;
    }

    @Generated
    public boolean isZoneKey() {
        return this.isZoneKey;
    }

    @Generated
    public boolean isSepKey() {
        return this.isSepKey;
    }

    @Generated
    public void setFlags(char flags) {
        this.flags = flags;
    }

    @Generated
    public void setProtocol(short protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setKeydata(byte[] keydata) {
        this.keydata = keydata;
    }

    @Generated
    public void setKeytag(int keytag) {
        this.keytag = keytag;
    }

    @Generated
    public void setZoneKey(boolean isZoneKey) {
        this.isZoneKey = isZoneKey;
    }

    @Generated
    public void setSepKey(boolean isSepKey) {
        this.isSepKey = isSepKey;
    }
}

