/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.edns0;

import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.edns0.EDNS0Option;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class ClientSubnetOption
extends EDNS0Option {
    private int fam;
    private int sourcenetmask;
    private int scopenetmask;
    private String address;
    private InetAddress inetAddress;

    public ClientSubnetOption() {
    }

    public ClientSubnetOption(int code, int len, NetworkData buffer) {
        super(code, len, buffer);
    }

    public String export() {
        return (this.fam == 1 ? "4," : "6,") + this.address + "/" + this.sourcenetmask + "," + this.scopenetmask;
    }

    public boolean isIPv4() {
        return this.fam == 1;
    }

    @Override
    public void decode(NetworkData buffer) {
        this.fam = buffer.readUnsignedChar();
        this.sourcenetmask = buffer.readUnsignedByte();
        this.scopenetmask = buffer.readUnsignedByte();
        int addrLength = this.len - 4;
        if (addrLength > 0) {
            byte[] addrBytes = new byte[]{};
            if (this.fam == 1) {
                addrBytes = buffer.readBytes(4, Math.min(4, addrLength));
            } else if (this.fam == 2) {
                addrBytes = buffer.readBytes(16, Math.min(16, addrLength));
            }
            try {
                this.inetAddress = InetAddress.getByAddress(addrBytes);
            }
            catch (UnknownHostException e) {
                throw new DnsDecodeException("Invalid IP address", e);
            }
            this.address = this.inetAddress.getHostAddress();
        }
    }

    @Generated
    public int getFam() {
        return this.fam;
    }

    @Generated
    public int getSourcenetmask() {
        return this.sourcenetmask;
    }

    @Generated
    public int getScopenetmask() {
        return this.scopenetmask;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Generated
    public void setFam(int fam) {
        this.fam = fam;
    }

    @Generated
    public void setSourcenetmask(int sourcenetmask) {
        this.sourcenetmask = sourcenetmask;
    }

    @Generated
    public void setScopenetmask(int scopenetmask) {
        this.scopenetmask = scopenetmask;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }
}

