/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import nl.sidnlabs.dnslib.message.records.dnssec.DNSKEYResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.DSResourceRecord;

public class KeyUtil {
    private static final char KEY_ZONE_FLAG_MASK = '\u0100';
    private static final char KEY_ZONE_SEP_FLAG_MASK = '\u0101';

    private KeyUtil() {
    }

    public static PublicKey createPublicKey(byte[] key, int algorithm) {
        if (algorithm == 5 || algorithm == 7 || algorithm == 8 || algorithm == 10) {
            ByteBuffer b = ByteBuffer.wrap(key);
            int exponentLength = b.get() & 0xFF;
            if (exponentLength == 0) {
                exponentLength = b.getChar();
            }
            try {
                byte[] data = new byte[exponentLength];
                b.get(data);
                BigInteger exponent = new BigInteger(1, data);
                byte[] modulusData = new byte[b.remaining()];
                b.get(modulusData);
                BigInteger modulus = new BigInteger(1, modulusData);
                KeyFactory factory = KeyFactory.getInstance("RSA");
                return factory.generatePublic(new RSAPublicKeySpec(modulus, exponent));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int createKeyTag(byte[] rdata, int alg) {
        int foot = 0;
        int footprint = -1;
        if (1 == alg) {
            int d1 = rdata[rdata.length - 3] & 0xFF;
            int d2 = rdata[rdata.length - 2] & 0xFF;
            foot = (d1 << 8) + d2;
        } else {
            int d1;
            int i;
            for (i = 0; i < rdata.length - 1; i += 2) {
                d1 = rdata[i] & 0xFF;
                int d2 = rdata[i + 1] & 0xFF;
                foot += (d1 << 8) + d2;
            }
            if (i < rdata.length) {
                d1 = rdata[i] & 0xFF;
                foot += d1 << 8;
            }
            foot += foot >> 16 & 0xFFFF;
        }
        footprint = foot & 0xFFFF;
        return footprint;
    }

    public static boolean isZoneKey(DNSKEYResourceRecord key) {
        return (key.getFlags() & 0x100) == 256;
    }

    public static boolean isSepKey(DNSKEYResourceRecord key) {
        return (key.getFlags() & 0x101) == 257;
    }

    public static boolean isKeyandDSmatch(DNSKEYResourceRecord key, DSResourceRecord ds) {
        return key.getAlgorithm() == ds.getAlgorithm() && key.getKeytag() == ds.getKeytag() && key.getName().equalsIgnoreCase(ds.getName());
    }
}

