/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.util;

import java.net.InetAddress;
import nl.sidnlabs.pcap.PcapReaderUtil;

public class IPv4Util {
    public static final int IP_PROTOCOL_OFFSET = 9;
    public static final int IP_SRC_OFFSET = 12;
    public static final int IP_VHL_OFFSET = 0;
    public static final int IP_TTL_OFFSET = 8;
    public static final int IP_DST_OFFSET = 16;
    public static final int IP_ID_OFFSET = 4;

    private IPv4Util() {
    }

    public static int decodeTTL(byte[] packetData, int ipStart) {
        return packetData[ipStart + 8] & 0xFF;
    }

    public static byte decodeProtocol(byte[] packetData, int ipStart) {
        return packetData[ipStart + 9];
    }

    public static InetAddress decodeSrc(byte[] packetData, int ipStart) {
        return PcapReaderUtil.convertDataToInetAddress(packetData, ipStart + 12, 4);
    }

    public static InetAddress decodeDst(byte[] packetData, int ipStart) {
        return PcapReaderUtil.convertDataToInetAddress(packetData, ipStart + 16, 4);
    }

    public static int decodeId(byte[] packetData, int ipStart) {
        return PcapReaderUtil.convertShort(packetData, ipStart + 4);
    }

    public static int getInternetProtocolHeaderVersion(byte[] packet, int ipStart) {
        return packet[ipStart + 0] >> 4 & 0xF;
    }

    public static int getInternetProtocolHeaderLength(byte[] packet, int ipStart) {
        return (packet[ipStart + 0] & 0xF) * 4;
    }
}

