/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap;

import com.google.common.collect.ComparisonChain;
import java.util.Arrays;

public class SequencePayload
implements Comparable<SequencePayload> {
    private Long seq;
    private byte[] payload;
    private long time;

    public SequencePayload() {
    }

    public SequencePayload(Long seq, byte[] payload, long time) {
        this.seq = seq;
        this.payload = payload;
        this.time = time;
    }

    @Override
    public int compareTo(SequencePayload o) {
        return ComparisonChain.start().compare((Comparable)this.seq, (Comparable)o.seq).compare(this.payload.length, o.payload.length).result();
    }

    public boolean linked(SequencePayload o) {
        if (this.seq + (long)this.payload.length == o.seq) {
            return true;
        }
        return o.seq + (long)o.payload.length == this.seq;
    }

    public Long getSeq() {
        return this.seq;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getTime() {
        return this.time;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequencePayload)) {
            return false;
        }
        SequencePayload other = (SequencePayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$seq = this.getSeq();
        Long other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        if (!Arrays.equals(this.getPayload(), other.getPayload())) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequencePayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        return result;
    }

    public String toString() {
        return "SequencePayload(seq=" + this.getSeq() + ", time=" + this.getTime() + ")";
    }
}

