/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import java.util.List;
import nl.sidn.dnslib.message.Message;
import nl.sidn.dnslib.message.util.NetworkData;
import nl.sidnlabs.pcap.packet.DNSPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DNSDecoder {
    private static final Logger log = LogManager.getLogger(DNSDecoder.class);
    private int dnsDecodeError;
    private int messageCounter;

    public int decode(DNSPacket packet, List<byte[]> payloads) {
        int counter = 0;
        for (byte[] payload : payloads) {
            this.decode(packet, payload);
            ++counter;
        }
        return counter;
    }

    public void decode(DNSPacket packet, byte[] payload) {
        this.decode(packet, payload, false);
    }

    public void decode(DNSPacket packet, byte[] payload, boolean allowFaill) {
        NetworkData nd = null;
        Message dnsMessage = null;
        nd = new NetworkData(payload);
        try {
            dnsMessage = new Message(nd, allowFaill);
            dnsMessage.setBytes(nd.length());
            packet.pushMessage(dnsMessage);
            ++this.messageCounter;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("error decoding maybe corrupt packet: " + packet, (Throwable)e);
            }
            ++this.dnsDecodeError;
        }
        if (log.isDebugEnabled() && packet.getProtocol() == 17 && nd.isBytesAvailable()) {
            log.debug("udp padding found for: " + packet.getSrc() + " " + packet.getSrcPort() + " pad bytes: " + (nd.length() - nd.getReaderIndex()));
        }
    }

    public void reset() {
        this.dnsDecodeError = 0;
        this.messageCounter = 0;
    }

    public int getDnsDecodeError() {
        return this.dnsDecodeError;
    }

    public int getMessageCounter() {
        return this.messageCounter;
    }

    public void setDnsDecodeError(int dnsDecodeError) {
        this.dnsDecodeError = dnsDecodeError;
    }

    public void setMessageCounter(int messageCounter) {
        this.messageCounter = messageCounter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DNSDecoder)) {
            return false;
        }
        DNSDecoder other = (DNSDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDnsDecodeError() != other.getDnsDecodeError()) {
            return false;
        }
        return this.getMessageCounter() == other.getMessageCounter();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DNSDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDnsDecodeError();
        result = result * 59 + this.getMessageCounter();
        return result;
    }

    public String toString() {
        return "DNSDecoder(dnsDecodeError=" + this.getDnsDecodeError() + ", messageCounter=" + this.getMessageCounter() + ")";
    }
}

