/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.decoder.DNSDecoder;
import nl.sidnlabs.pcap.decoder.IPDecoder;
import nl.sidnlabs.pcap.decoder.TCPDecoder;
import nl.sidnlabs.pcap.decoder.UDPDecoder;
import nl.sidnlabs.pcap.packet.DNSPacket;
import nl.sidnlabs.pcap.packet.ICMPPacket;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.util.ICMPv4Util;
import nl.sidnlabs.pcap.util.ICMPv6Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ICMPDecoder {
    private static final Logger log = LogManager.getLogger(ICMPDecoder.class);
    public static final int PROTOCOL_ICMP_V4 = 1;
    public static final int PROTOCOL_ICMP_V6 = 58;
    public static final int PROTOCOL_ICMP_V6_OFFSET_INFO_MSG = 128;
    public static final int PROTOCOL_ICMP_V4_ECHO_REQUEST = 8;
    public static final int PROTOCOL_ICMP_V4_ECHO_REPLY = 0;
    public static final int PROTOCOL_ICMP_V6_ECHO_REQUEST = 128;
    public static final int PROTOCOL_ICMP_V6_ECHO_REPLY = 129;
    public static final int PROTOCOL_ICMP_DESTINATION_UNREACHABLE = 3;
    public static final int PROTOCOL_ICMP_SOURCE_QUENCHE = 4;
    public static final int PROTOCOL_ICMP_REDIRECT_MESSAGE = 5;
    public static final int PROTOCOL_ICMP_TIME_EXCEEDED = 11;
    public static final int PROTOCOL_ICMP_PARAMETER_PROBLEM = 12;
    public static final String ECHO_CLIENT_ID_RIPE_ATLAS = "http://atlas.ripe.net";
    public static final String ECHO_CLIENT_ID_UNIX_LINUX = "!\"#$%&'()*+,-./01234567";
    public static final String ECHO_CLIENT_ID_WINDOWS = "abcdefghijklmnopqrstuvwabcdefghi";
    public static final String ECHO_CLIENT_ID_PRTG = "P\u0000I\u0000N\u0000G\u0000 \u0000b\u0000y\u0000 \u0000P\u0000R\u0000T\u0000G\u0000";
    public static final int ECHO_CLIENT_TYPE_UNKNOWN = 0;
    public static final int ECHO_CLIENT_TYPE_RIPE_ATLAS = 1;
    public static final int ECHO_CLIENT_TYPE_UNIX_LINUX = 2;
    public static final int ECHO_CLIENT_TYPE_WINDOWS = 3;
    public static final int ECHO_CLIENT_TYPE_PRTG = 4;
    private IPDecoder ipDecoder = new IPDecoder();
    private UDPDecoder udpDecoder = new UDPDecoder();
    private TCPDecoder tcpDecoder = new TCPDecoder();
    private DNSDecoder dnsDecoder = new DNSDecoder();

    public void reassemble(ICMPPacket packet, int ipStart, byte[] packetData) {
        int payloadDataStart = ipStart + packet.getIpHeaderLen();
        int payloadLength = packetData.length - packet.getIpHeaderLen();
        byte[] payload = PcapReaderUtil.readPayload(packetData, payloadDataStart, payloadLength);
        this.decode(packet, payload);
    }

    public void decode(ICMPPacket packet, byte[] packetData) {
        if (packet.getIpVersion() == 4) {
            packet.setType(ICMPv4Util.decodeType(packetData));
            packet.setCode(ICMPv4Util.decodeCode(packetData));
            if (packet.getType() == 3 || packet.getType() == 4 || packet.getType() == 5 || packet.getType() == 11 || packet.getType() == 12) {
                this.decodePayload(packet, ICMPv4Util.extractPayload(packetData));
                packet.setError(true);
            } else {
                packet.setOriginalIPPacket(Packet.NULL);
                packet.setInfo(true);
            }
        } else {
            packet.setType(ICMPv6Util.decodeType(packetData));
            packet.setCode(ICMPv6Util.decodeCode(packetData));
            if (packet.getType() < 128) {
                this.decodePayload(packet, ICMPv6Util.extractPayload(packetData));
                packet.setError(true);
            } else {
                packet.setOriginalIPPacket(Packet.NULL);
                packet.setInfo(true);
            }
        }
        if (packet.getType() == 8 || packet.getType() == 0 || packet.getType() == 128 || packet.getType() == 129) {
            if (this.isClientRipeAtlas(packetData)) {
                packet.setClientType(1);
            } else if (this.isClientUnixLinux(packetData)) {
                packet.setClientType(2);
            } else if (this.isClientWindows(packetData)) {
                packet.setClientType(3);
            } else if (this.isClientPrtg(packetData)) {
                packet.setClientType(4);
            } else if (log.isDebugEnabled()) {
                byte[] echoBytes = ICMPv4Util.extractEchoRequestPayload(packetData);
                String echoStr = new String(echoBytes);
                log.debug(packet.getSrc() + ": " + echoStr);
            }
        }
    }

    private void decodePayload(ICMPPacket packet, byte[] icmpPayload) {
        Packet ipPacket = this.ipDecoder.decode(icmpPayload, 0);
        packet.setOriginalIPPacket(ipPacket);
        if (ipPacket == Packet.NULL) {
            return;
        }
        if (ipPacket instanceof DNSPacket) {
            DNSPacket dnsPacket = (DNSPacket)ipPacket;
            byte[] layer4Payload = null;
            if (17 == ipPacket.getProtocol()) {
                layer4Payload = this.udpDecoder.reassemble(ipPacket, ipPacket.getIpHeaderLen(), icmpPayload.length, 0, icmpPayload);
            } else if (6 == ipPacket.getProtocol()) {
                layer4Payload = this.tcpDecoder.decode(ipPacket, icmpPayload, 0, ipPacket.getIpHeaderLen(), icmpPayload.length);
            }
            if (layer4Payload != null && layer4Payload.length > 0) {
                this.dnsDecoder.decode(dnsPacket, layer4Payload, true);
                if (dnsPacket.getMessageCount() > 0) {
                    dnsPacket.getMessages().get(0).setBytes(ipPacket.getPayloadLength());
                }
            }
        } else if (ipPacket instanceof ICMPPacket) {
            int payloadDataStart = ipPacket.getIpHeaderLen();
            int payloadLength = icmpPayload.length - payloadDataStart;
            byte[] payload = PcapReaderUtil.readPayload(icmpPayload, payloadDataStart, payloadLength);
            this.decode((ICMPPacket)ipPacket, payload);
        }
    }

    private boolean isClientRipeAtlas(byte[] packetData) {
        byte[] echoBytes = ICMPv4Util.extractEchoRequestPayload(packetData);
        String echoStr = new String(echoBytes);
        return StringUtils.contains((CharSequence)echoStr, (CharSequence)ECHO_CLIENT_ID_RIPE_ATLAS);
    }

    private boolean isClientUnixLinux(byte[] packetData) {
        return this.isClient(packetData, ECHO_CLIENT_ID_UNIX_LINUX);
    }

    private boolean isClientWindows(byte[] packetData) {
        return this.isClient(packetData, ECHO_CLIENT_ID_WINDOWS);
    }

    private boolean isClientPrtg(byte[] packetData) {
        return this.isClient(packetData, ECHO_CLIENT_ID_PRTG);
    }

    private boolean isClient(byte[] packetData, String id) {
        byte[] echoBytes = ICMPv4Util.extractEchoRequestPayload(packetData);
        String echoStr = new String(echoBytes);
        return StringUtils.contains((CharSequence)echoStr, (CharSequence)id);
    }

    public IPDecoder getIpDecoder() {
        return this.ipDecoder;
    }

    public UDPDecoder getUdpDecoder() {
        return this.udpDecoder;
    }

    public TCPDecoder getTcpDecoder() {
        return this.tcpDecoder;
    }

    public DNSDecoder getDnsDecoder() {
        return this.dnsDecoder;
    }

    public void setIpDecoder(IPDecoder ipDecoder) {
        this.ipDecoder = ipDecoder;
    }

    public void setUdpDecoder(UDPDecoder udpDecoder) {
        this.udpDecoder = udpDecoder;
    }

    public void setTcpDecoder(TCPDecoder tcpDecoder) {
        this.tcpDecoder = tcpDecoder;
    }

    public void setDnsDecoder(DNSDecoder dnsDecoder) {
        this.dnsDecoder = dnsDecoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ICMPDecoder)) {
            return false;
        }
        ICMPDecoder other = (ICMPDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPDecoder this$ipDecoder = this.getIpDecoder();
        IPDecoder other$ipDecoder = other.getIpDecoder();
        if (this$ipDecoder == null ? other$ipDecoder != null : !((Object)this$ipDecoder).equals(other$ipDecoder)) {
            return false;
        }
        UDPDecoder this$udpDecoder = this.getUdpDecoder();
        UDPDecoder other$udpDecoder = other.getUdpDecoder();
        if (this$udpDecoder == null ? other$udpDecoder != null : !this$udpDecoder.equals(other$udpDecoder)) {
            return false;
        }
        TCPDecoder this$tcpDecoder = this.getTcpDecoder();
        TCPDecoder other$tcpDecoder = other.getTcpDecoder();
        if (this$tcpDecoder == null ? other$tcpDecoder != null : !((Object)this$tcpDecoder).equals(other$tcpDecoder)) {
            return false;
        }
        DNSDecoder this$dnsDecoder = this.getDnsDecoder();
        DNSDecoder other$dnsDecoder = other.getDnsDecoder();
        return !(this$dnsDecoder == null ? other$dnsDecoder != null : !((Object)this$dnsDecoder).equals(other$dnsDecoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ICMPDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPDecoder $ipDecoder = this.getIpDecoder();
        result = result * 59 + ($ipDecoder == null ? 43 : ((Object)$ipDecoder).hashCode());
        UDPDecoder $udpDecoder = this.getUdpDecoder();
        result = result * 59 + ($udpDecoder == null ? 43 : $udpDecoder.hashCode());
        TCPDecoder $tcpDecoder = this.getTcpDecoder();
        result = result * 59 + ($tcpDecoder == null ? 43 : ((Object)$tcpDecoder).hashCode());
        DNSDecoder $dnsDecoder = this.getDnsDecoder();
        result = result * 59 + ($dnsDecoder == null ? 43 : ((Object)$dnsDecoder).hashCode());
        return result;
    }

    public String toString() {
        return "ICMPDecoder(ipDecoder=" + this.getIpDecoder() + ", udpDecoder=" + this.getUdpDecoder() + ", tcpDecoder=" + this.getTcpDecoder() + ", dnsDecoder=" + this.getDnsDecoder() + ")";
    }
}

