/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Collection;
import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.packet.Datagram;
import nl.sidnlabs.pcap.packet.DatagramPayload;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.packet.PacketFactory;
import nl.sidnlabs.pcap.util.IPv4Util;
import nl.sidnlabs.pcap.util.IPv6Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPDecoder {
    private static final Logger log = LogManager.getLogger(IPDecoder.class);
    public static final int IP_PROTOCOL_VERSION_4 = 4;
    public static final int IP_PROTOCOL_VERSION_6 = 6;
    public static final int IP_TOTAL_LEN_OFFSET = 2;
    public static final int IP_FLAGS = 6;
    public static final int IP_FRAGMENT_OFFSET = 6;
    private Multimap<Datagram, DatagramPayload> datagrams = TreeMultimap.create();

    public Packet decode(byte[] packetData, int ipStart) {
        if (ipStart == -1) {
            return Packet.NULL;
        }
        int ipProtocolHeaderVersion = IPv4Util.getInternetProtocolHeaderVersion(packetData, ipStart);
        int protocol = -1;
        if (ipProtocolHeaderVersion == 4) {
            protocol = IPv4Util.decodeProtocol(packetData, ipStart);
        } else if (ipProtocolHeaderVersion == 6) {
            protocol = IPv6Util.decodeProtocol(packetData, ipStart);
        } else {
            log.error("Unsupported IP version " + ipProtocolHeaderVersion + " ipstart=" + ipStart);
            return Packet.NULL;
        }
        Packet packet = PacketFactory.create(protocol);
        if (packet == Packet.NULL) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid protocol " + protocol);
            }
            return packet;
        }
        packet.setIpVersion((byte)ipProtocolHeaderVersion);
        int totalLength = 0;
        if (ipProtocolHeaderVersion == 4) {
            int ipHeaderLen = IPv4Util.getInternetProtocolHeaderLength(packetData, ipStart);
            packet.setIpHeaderLen(ipHeaderLen);
            this.buildInternetProtocolV4Packet(packet, packetData, ipStart);
            totalLength = PcapReaderUtil.convertShort(packetData, ipStart + 2);
            this.decodeV4Fragmented(packet, ipStart, packetData);
        } else {
            int ipHeaderLen = IPv6Util.getInternetProtocolHeaderLength(packetData, ipStart);
            packet.setIpHeaderLen(ipHeaderLen);
            this.buildInternetProtocolV6Packet(packet, packetData, ipStart);
            int payloadLength = PcapReaderUtil.convertShort(packetData, ipStart + 4);
            totalLength = payloadLength + 40;
            this.decodeV6Fragmented(packet, ipStart, packetData);
            if (packet.isFragmented()) {
                IPv6Util.buildInternetProtocolV6ExtensionHeaderFragment(packet, packetData, ipStart);
            }
        }
        packet.setTotalLength(totalLength);
        return packet;
    }

    private void decodeV6Fragmented(Packet packet, int ipStart, byte[] packetData) {
        byte nxtHdr = packetData[ipStart + 6];
        packet.setFragmented(nxtHdr == 44);
    }

    private void decodeV4Fragmented(Packet packet, int ipStart, byte[] packetData) {
        long fragmentOffset = (long)(PcapReaderUtil.convertShort(packetData, ipStart + 6) & 0x1FFF) * 8L;
        packet.setFragOffset(fragmentOffset);
        int flags = packetData[ipStart + 6] & 0xE0;
        if ((flags & 0x20) != 0 || fragmentOffset != 0L) {
            packet.setFragmented(true);
            packet.setLastFragment((flags & 0x20) == 0 && fragmentOffset != 0L);
        } else {
            packet.setFragmented(false);
        }
    }

    private void buildInternetProtocolV4Packet(Packet packet, byte[] packetData, int ipStart) {
        packet.setTtl(IPv4Util.decodeTTL(packetData, ipStart));
        packet.setSrc(IPv4Util.decodeSrc(packetData, ipStart));
        packet.setDst(IPv4Util.decodeDst(packetData, ipStart));
        packet.setIpId(IPv4Util.decodeId(packetData, ipStart));
    }

    private void buildInternetProtocolV6Packet(Packet packet, byte[] packetData, int ipStart) {
        packet.setTtl(IPv6Util.decodeTTL(packetData, ipStart));
        packet.setSrc(IPv6Util.decodeSrc(packetData, ipStart));
        packet.setDst(IPv6Util.decodeDst(packetData, ipStart));
        packet.setIpId(IPv6Util.decodeId(packetData, ipStart));
    }

    public byte[] reassemble(Packet packet, byte[] packetData, int ipStart) {
        byte[] reassmbledPacketData = packetData;
        if (packet.isFragmented()) {
            Datagram datagram = packet.getDatagram();
            byte[] fragmentPacketData = Arrays.copyOfRange(packetData, ipStart + packet.getIpHeaderLen(), ipStart + packet.getTotalLength());
            DatagramPayload payload = new DatagramPayload(packet.getFragOffset(), fragmentPacketData);
            this.datagrams.put((Object)datagram, (Object)payload);
            if (packet.isLastFragment()) {
                Collection datagramPayloads = this.datagrams.removeAll((Object)datagram);
                if (datagramPayloads != null && !datagramPayloads.isEmpty()) {
                    reassmbledPacketData = Arrays.copyOfRange(packetData, 0, ipStart + packet.getIpHeaderLen());
                    int reassembledFragments = 0;
                    DatagramPayload prev = null;
                    for (DatagramPayload datagramPayload : datagramPayloads) {
                        if (prev == null && datagramPayload.getOffset() != 0L) {
                            if (log.isDebugEnabled()) {
                                log.debug("Datagram chain not starting at 0. Probably received packets out-of-order. Can't reassemble this packet.");
                            }
                            return new byte[0];
                        }
                        if (prev != null && !datagramPayload.linked(prev)) {
                            if (log.isDebugEnabled()) {
                                log.debug("Broken datagram chain between " + datagramPayload + " and " + prev + ". Can't reassemble this packet.");
                            }
                            return new byte[0];
                        }
                        reassmbledPacketData = Bytes.concat((byte[][])new byte[][]{reassmbledPacketData, datagramPayload.getPayload()});
                        ++reassembledFragments;
                        prev = datagramPayload;
                    }
                    if (reassembledFragments == datagramPayloads.size()) {
                        packet.setReassembledFragments(reassembledFragments);
                    }
                }
            } else {
                reassmbledPacketData = new byte[]{};
            }
        }
        return reassmbledPacketData;
    }

    public Multimap<Datagram, DatagramPayload> getDatagrams() {
        return this.datagrams;
    }

    public void setDatagrams(Multimap<Datagram, DatagramPayload> datagrams) {
        this.datagrams = datagrams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPDecoder)) {
            return false;
        }
        IPDecoder other = (IPDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Multimap<Datagram, DatagramPayload> this$datagrams = this.getDatagrams();
        Multimap<Datagram, DatagramPayload> other$datagrams = other.getDatagrams();
        return !(this$datagrams == null ? other$datagrams != null : !this$datagrams.equals(other$datagrams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap<Datagram, DatagramPayload> $datagrams = this.getDatagrams();
        result = result * 59 + ($datagrams == null ? 43 : $datagrams.hashCode());
        return result;
    }

    public String toString() {
        return "IPDecoder(datagrams=" + this.getDatagrams() + ")";
    }
}

