/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.SequencePayload;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.packet.TCPFlow;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPDecoder {
    private static final Logger log = LogManager.getLogger(TCPDecoder.class);
    public static final int PROTOCOL_HEADER_TCP_SEQ_OFFSET = 4;
    public static final int PROTOCOL_HEADER_TCP_ACK_OFFSET = 8;
    public static final int TCP_HEADER_DATA_OFFSET = 12;
    public static final int PROTOCOL_HEADER_WINDOW_SIZE_OFFSET = 14;
    public static final byte[] EMPTY_PAYLOAD = new byte[0];
    protected Multimap<TCPFlow, SequencePayload> flows = TreeMultimap.create();
    protected Multimap<TCPFlow, Long> flowseq = TreeMultimap.create();
    private int tcpPrefixError = 0;

    public byte[] decode(Packet packet, byte[] packetData, int ipStart, int ipHeaderLen, int totalLength) {
        packet.setSrcPort(PcapReaderUtil.convertShort(packetData, ipStart + ipHeaderLen + 0));
        packet.setDstPort(PcapReaderUtil.convertShort(packetData, ipStart + ipHeaderLen + 2));
        int tcpOrUdpHeaderSize = this.getTcpHeaderLength(packetData, ipStart + ipHeaderLen);
        if (tcpOrUdpHeaderSize == -1) {
            return new byte[0];
        }
        packet.setTcpHeaderLen(tcpOrUdpHeaderSize);
        packet.setTcpSeq(PcapReaderUtil.convertUnsignedInt(packetData, ipStart + ipHeaderLen + 4));
        packet.setTcpAck(PcapReaderUtil.convertUnsignedInt(packetData, ipStart + ipHeaderLen + 8));
        int flags = PcapReaderUtil.convertShort(new byte[]{packetData[ipStart + ipHeaderLen + 12], packetData[ipStart + ipHeaderLen + 12 + 1]}) & 0x1FF;
        packet.setTcpFlagNs((flags & 0x100) != 0);
        packet.setTcpFlagCwr((flags & 0x80) != 0);
        packet.setTcpFlagEce((flags & 0x40) != 0);
        packet.setTcpFlagUrg((flags & 0x20) != 0);
        packet.setTcpFlagAck((flags & 0x10) != 0);
        packet.setTcpFlagPsh((flags & 8) != 0);
        packet.setTcpFlagRst((flags & 4) != 0);
        packet.setTcpFlagSyn((flags & 2) != 0);
        packet.setTcpFlagFin((flags & 1) != 0);
        packet.setTcpWindowSize(PcapReaderUtil.convertShort(packetData, ipStart + ipHeaderLen + 14));
        int payloadDataStart = ipStart + ipHeaderLen + tcpOrUdpHeaderSize;
        int payloadLength = totalLength - ipHeaderLen - tcpOrUdpHeaderSize;
        byte[] data = PcapReaderUtil.readPayload(packetData, payloadDataStart, payloadLength);
        packet.setPayloadLength(payloadLength);
        packet.setUdpLength(packetData.length);
        return data;
    }

    public byte[] reassemble(Packet packet, int ipHeaderLen, int totalLength, int ipStart, byte[] packetData) {
        Collection fragments;
        byte[] packetPayload = this.decode(packet, packetData, ipStart, ipHeaderLen, totalLength);
        if (packet.getSrcPort() != 53 && packet.getDstPort() != 53) {
            return EMPTY_PAYLOAD;
        }
        TCPFlow flow = packet.getFlow();
        if (packetPayload.length > 0) {
            SequencePayload sequencePayload = new SequencePayload(packet.getTcpSeq(), packetPayload, System.currentTimeMillis());
            this.flows.put((Object)flow, (Object)sequencePayload);
        }
        if ((packet.isTcpFlagFin() || packet.isTcpFlagPsh()) && (fragments = this.flows.removeAll((Object)flow)) != null && fragments.size() > 0) {
            packet.setReassembledTCPFragments(fragments.size());
            SequencePayload prev = null;
            int totalSize = 0;
            for (SequencePayload seqPayload : fragments) {
                totalSize += seqPayload.getPayload().length;
            }
            packetPayload = new byte[totalSize];
            int destPos = 0;
            for (SequencePayload seqPayload : fragments) {
                if (prev != null && !seqPayload.linked(prev)) {
                    log.warn("Broken sequence chain between " + seqPayload + " and " + prev + ". Returning empty payload.");
                    packetPayload = EMPTY_PAYLOAD;
                    ++this.tcpPrefixError;
                    break;
                }
                System.arraycopy(seqPayload.getPayload(), 0, packetPayload, destPos, seqPayload.getPayload().length);
                destPos += seqPayload.getPayload().length;
                prev = seqPayload;
            }
            return packetPayload;
        }
        return EMPTY_PAYLOAD;
    }

    private int getTcpHeaderLength(byte[] packet, int tcpStart) {
        int dataOffset = tcpStart + 12;
        if (dataOffset < packet.length) {
            return (packet[dataOffset] >> 4 & 0xF) * 4;
        }
        return -1;
    }

    public Multimap<TCPFlow, SequencePayload> getFlows() {
        return this.flows;
    }

    public Multimap<TCPFlow, Long> getFlowseq() {
        return this.flowseq;
    }

    public int getTcpPrefixError() {
        return this.tcpPrefixError;
    }

    public void setFlows(Multimap<TCPFlow, SequencePayload> flows) {
        this.flows = flows;
    }

    public void setFlowseq(Multimap<TCPFlow, Long> flowseq) {
        this.flowseq = flowseq;
    }

    public void setTcpPrefixError(int tcpPrefixError) {
        this.tcpPrefixError = tcpPrefixError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TCPDecoder)) {
            return false;
        }
        TCPDecoder other = (TCPDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Multimap<TCPFlow, SequencePayload> this$flows = this.getFlows();
        Multimap<TCPFlow, SequencePayload> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !this$flows.equals(other$flows)) {
            return false;
        }
        Multimap<TCPFlow, Long> this$flowseq = this.getFlowseq();
        Multimap<TCPFlow, Long> other$flowseq = other.getFlowseq();
        if (this$flowseq == null ? other$flowseq != null : !this$flowseq.equals(other$flowseq)) {
            return false;
        }
        return this.getTcpPrefixError() == other.getTcpPrefixError();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TCPDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap<TCPFlow, SequencePayload> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : $flows.hashCode());
        Multimap<TCPFlow, Long> $flowseq = this.getFlowseq();
        result = result * 59 + ($flowseq == null ? 43 : $flowseq.hashCode());
        result = result * 59 + this.getTcpPrefixError();
        return result;
    }

    public String toString() {
        return "TCPDecoder(flows=" + this.getFlows() + ", flowseq=" + this.getFlowseq() + ", tcpPrefixError=" + this.getTcpPrefixError() + ")";
    }
}

