/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.util.UDPUtil;

public class UDPDecoder {
    public byte[] reassemble(Packet packet, int ipHeaderLen, int totalLength, int ipStart, byte[] packetData) {
        int cksum;
        packet.setSrcPort(PcapReaderUtil.convertShort(packetData, ipStart + ipHeaderLen + 0));
        packet.setDstPort(PcapReaderUtil.convertShort(packetData, ipStart + ipHeaderLen + 2));
        if (packet.getIpVersion() == 4 && (cksum = UDPUtil.getUdpChecksum(packetData, ipStart, ipHeaderLen)) >= 0) {
            packet.setUdpsum(cksum);
        }
        int payloadDataStart = ipStart + ipHeaderLen + 8;
        int payloadLength = totalLength - ipHeaderLen - 8;
        byte[] packetPayload = PcapReaderUtil.readPayload(packetData, payloadDataStart, payloadLength);
        packet.setUdpLength(totalLength);
        packet.setPayloadLength(UDPUtil.getUdpLen(packetData, ipStart, ipHeaderLen));
        if (packet.getFragOffset() == 0L && packet.getSrcPort() != 53 && packet.getDstPort() != 53) {
            return null;
        }
        return packetPayload;
    }
}

