/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import com.google.common.collect.ComparisonChain;
import java.util.Arrays;

public class DatagramPayload
implements Comparable<DatagramPayload> {
    private Long offset;
    private byte[] payload;

    public DatagramPayload(Long offset, byte[] payload) {
        this.offset = offset;
        this.payload = payload;
    }

    @Override
    public int compareTo(DatagramPayload o) {
        return ComparisonChain.start().compare((Comparable)this.offset, (Comparable)o.offset).compare(this.payload.length, o.payload.length).result();
    }

    public boolean linked(DatagramPayload o) {
        if (this.offset + (long)this.payload.length == o.offset) {
            return true;
        }
        return o.offset + (long)o.payload.length == this.offset;
    }

    public Long getOffset() {
        return this.offset;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatagramPayload)) {
            return false;
        }
        DatagramPayload other = (DatagramPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$offset = this.getOffset();
        Long other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatagramPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    public String toString() {
        return "DatagramPayload(offset=" + this.getOffset() + ")";
    }
}

