/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.util;

import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.packet.Packet;

public class IPv6Util {
    public static final int IPV6_HEADER_SIZE = 40;
    public static final int IPV6_PAYLOAD_LEN_OFFSET = 4;
    public static final int IPV6_HOPLIMIT_OFFSET = 7;
    public static final int IPV6_NEXTHEADER_OFFSET = 6;
    public static final int IPV6_SRC_OFFSET = 8;
    public static final int IPV6_DST_OFFSET = 24;
    public static final int IPV6_FRAGMENT_EXTENTION_TYPE = 44;
    public static final int IPV6_FRAGMENT_EXTENTION_SIZE = 8;
    public static final int IPV6_FRAGMENT_OFFSET = 2;
    public static final int IPV6_MFLAG_OFFSET = 3;
    public static final int IPV6_ID_OFFSET = 4;

    private IPv6Util() {
    }

    public static int decodeProtocol(byte[] packetData, int ipStart) {
        byte protocol = packetData[ipStart + 6];
        if (protocol == 44) {
            protocol = packetData[ipStart + 40];
        }
        return protocol;
    }

    public static int decodeTTL(byte[] packetData, int ipStart) {
        return packetData[ipStart + 7] & 0xFF;
    }

    public static String decodeSrc(byte[] packetData, int ipStart) {
        return PcapReaderUtil.convertAddress(packetData, ipStart + 8, 16);
    }

    public static String decodeDst(byte[] packetData, int ipStart) {
        return PcapReaderUtil.convertAddress(packetData, ipStart + 24, 16);
    }

    public static long decodeId(byte[] packetData, int ipStart) {
        byte nxtHdr = packetData[ipStart + 6];
        if (nxtHdr == 44) {
            return PcapReaderUtil.convertUnsignedInt(packetData, ipStart + 40 + 4);
        }
        return 0L;
    }

    public static int getInternetProtocolHeaderLength(byte[] packet, int ipStart) {
        byte protocol = packet[ipStart + 6];
        if (protocol == 44) {
            return 48;
        }
        return 40;
    }

    public static int buildInternetProtocolV6ExtensionHeaderFragment(Packet packet, byte[] packetData, int ipStart) {
        if (packet.isFragmented()) {
            long id = PcapReaderUtil.convertUnsignedInt(packetData, ipStart + 40 + 4);
            packet.setIpId(id);
            int flags = packetData[ipStart + 40 + 3] & 7;
            packet.setFragmentFlagM((flags & 1) == 0);
            long fragmentOffset = PcapReaderUtil.convertShort(packetData, ipStart + 40 + 2) & 0xFFF8;
            packet.setFragOffset(fragmentOffset);
            packet.setLastFragment((flags & 1) == 0 && fragmentOffset != 0L);
            byte protocol = packetData[ipStart + 40];
            packet.setProtocol(protocol);
            return 8;
        }
        return 0;
    }
}

