/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.util;

import nl.sidnlabs.pcap.PcapReaderUtil;

public class UDPUtil {
    public static final int UDP_HEADER_SIZE = 8;
    public static final int UDP_HEADER_LEN_OFFSET = 4;

    private UDPUtil() {
    }

    public static byte[] extractPayload(byte[] packetData) {
        int length = packetData.length - 8;
        byte[] data = new byte[length];
        System.arraycopy(packetData, 8, data, 0, length);
        return data;
    }

    public static int getUdpLen(byte[] packetData, int ipStart, int ipHeaderLen) {
        return PcapReaderUtil.convertShort(packetData, ipStart + ipHeaderLen + 4) - 8;
    }

    public static int getUdpChecksum(byte[] packetData, int ipStart, int ipHeaderLen) {
        if (packetData[ipStart + ipHeaderLen + 6] == 0 && packetData[ipStart + ipHeaderLen + 7] == 0) {
            return -1;
        }
        byte[] data = new byte[packetData.length - ipStart - ipHeaderLen + 12];
        int sum = 0;
        System.arraycopy(packetData, ipStart + 12, data, 0, 4);
        System.arraycopy(packetData, ipStart + 16, data, 4, 4);
        data[8] = 0;
        data[9] = 17;
        System.arraycopy(packetData, ipStart + ipHeaderLen + 4, data, 10, 2);
        System.arraycopy(packetData, ipStart + ipHeaderLen, data, 12, packetData.length - ipStart - ipHeaderLen);
        for (int i = 0; i < data.length; ++i) {
            int j = data[i];
            if (j < 0) {
                j += 256;
            }
            sum += j << (i % 2 == 0 ? 8 : 0);
        }
        sum = (sum >> 16) + (sum & 0xFFFF);
        sum += sum >> 16;
        return ~sum & 0xFFFF;
    }
}

