/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import nl.sidnlabs.pcap.packet.Datagram;
import nl.sidnlabs.pcap.packet.TCPFlow;

public class Packet {
    public static final Packet NULL = new Packet();
    protected int len;
    protected long ts;
    protected long tsmicros;
    protected double tsUsec;
    protected long ipId;
    protected int ttl;
    protected byte ipVersion;
    protected int ipHeaderLen;
    protected short protocol;
    protected String src;
    protected String dst;
    protected long fragOffset;
    protected boolean fragmented;
    protected boolean lastFragment;
    protected int reassembledFragments;
    protected boolean fragmentFlagM;
    protected int reassembledTCPFragments;
    protected int srcPort;
    protected int dstPort;
    protected int tcpflow;
    protected int udpsum;
    protected int udpLength;
    protected int tcpHeaderLen;
    protected long tcpSeq;
    protected long tcpAck;
    protected boolean tcpFlagNs;
    protected boolean tcpFlagCwr;
    protected boolean tcpFlagEce;
    protected boolean tcpFlagUrg;
    protected boolean tcpFlagAck;
    protected boolean tcpFlagPsh;
    protected boolean tcpFlagRst;
    protected boolean tcpFlagSyn;
    protected boolean tcpFlagFin;
    protected int tcpWindowSize;
    private int totalLength;
    protected int payloadLength;

    public TCPFlow getFlow() {
        return new TCPFlow(this.src, this.srcPort, this.dst, this.dstPort, this.protocol);
    }

    public Datagram getDatagram() {
        return new Datagram(this.getSrc(), this.getDst(), this.getIpId(), String.valueOf(this.getProtocol()), System.currentTimeMillis());
    }

    public boolean isIPv4() {
        return this.getIpVersion() == 4;
    }

    public boolean isIPv6() {
        return this.getIpVersion() == 6;
    }

    public int getLen() {
        return this.len;
    }

    public long getTs() {
        return this.ts;
    }

    public long getTsmicros() {
        return this.tsmicros;
    }

    public double getTsUsec() {
        return this.tsUsec;
    }

    public long getIpId() {
        return this.ipId;
    }

    public int getTtl() {
        return this.ttl;
    }

    public byte getIpVersion() {
        return this.ipVersion;
    }

    public int getIpHeaderLen() {
        return this.ipHeaderLen;
    }

    public short getProtocol() {
        return this.protocol;
    }

    public String getSrc() {
        return this.src;
    }

    public String getDst() {
        return this.dst;
    }

    public long getFragOffset() {
        return this.fragOffset;
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public boolean isLastFragment() {
        return this.lastFragment;
    }

    public int getReassembledFragments() {
        return this.reassembledFragments;
    }

    public boolean isFragmentFlagM() {
        return this.fragmentFlagM;
    }

    public int getReassembledTCPFragments() {
        return this.reassembledTCPFragments;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public int getTcpflow() {
        return this.tcpflow;
    }

    public int getUdpsum() {
        return this.udpsum;
    }

    public int getUdpLength() {
        return this.udpLength;
    }

    public int getTcpHeaderLen() {
        return this.tcpHeaderLen;
    }

    public long getTcpSeq() {
        return this.tcpSeq;
    }

    public long getTcpAck() {
        return this.tcpAck;
    }

    public boolean isTcpFlagNs() {
        return this.tcpFlagNs;
    }

    public boolean isTcpFlagCwr() {
        return this.tcpFlagCwr;
    }

    public boolean isTcpFlagEce() {
        return this.tcpFlagEce;
    }

    public boolean isTcpFlagUrg() {
        return this.tcpFlagUrg;
    }

    public boolean isTcpFlagAck() {
        return this.tcpFlagAck;
    }

    public boolean isTcpFlagPsh() {
        return this.tcpFlagPsh;
    }

    public boolean isTcpFlagRst() {
        return this.tcpFlagRst;
    }

    public boolean isTcpFlagSyn() {
        return this.tcpFlagSyn;
    }

    public boolean isTcpFlagFin() {
        return this.tcpFlagFin;
    }

    public int getTcpWindowSize() {
        return this.tcpWindowSize;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setTsmicros(long tsmicros) {
        this.tsmicros = tsmicros;
    }

    public void setTsUsec(double tsUsec) {
        this.tsUsec = tsUsec;
    }

    public void setIpId(long ipId) {
        this.ipId = ipId;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setIpVersion(byte ipVersion) {
        this.ipVersion = ipVersion;
    }

    public void setIpHeaderLen(int ipHeaderLen) {
        this.ipHeaderLen = ipHeaderLen;
    }

    public void setProtocol(short protocol) {
        this.protocol = protocol;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setFragOffset(long fragOffset) {
        this.fragOffset = fragOffset;
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    public void setLastFragment(boolean lastFragment) {
        this.lastFragment = lastFragment;
    }

    public void setReassembledFragments(int reassembledFragments) {
        this.reassembledFragments = reassembledFragments;
    }

    public void setFragmentFlagM(boolean fragmentFlagM) {
        this.fragmentFlagM = fragmentFlagM;
    }

    public void setReassembledTCPFragments(int reassembledTCPFragments) {
        this.reassembledTCPFragments = reassembledTCPFragments;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public void setTcpflow(int tcpflow) {
        this.tcpflow = tcpflow;
    }

    public void setUdpsum(int udpsum) {
        this.udpsum = udpsum;
    }

    public void setUdpLength(int udpLength) {
        this.udpLength = udpLength;
    }

    public void setTcpHeaderLen(int tcpHeaderLen) {
        this.tcpHeaderLen = tcpHeaderLen;
    }

    public void setTcpSeq(long tcpSeq) {
        this.tcpSeq = tcpSeq;
    }

    public void setTcpAck(long tcpAck) {
        this.tcpAck = tcpAck;
    }

    public void setTcpFlagNs(boolean tcpFlagNs) {
        this.tcpFlagNs = tcpFlagNs;
    }

    public void setTcpFlagCwr(boolean tcpFlagCwr) {
        this.tcpFlagCwr = tcpFlagCwr;
    }

    public void setTcpFlagEce(boolean tcpFlagEce) {
        this.tcpFlagEce = tcpFlagEce;
    }

    public void setTcpFlagUrg(boolean tcpFlagUrg) {
        this.tcpFlagUrg = tcpFlagUrg;
    }

    public void setTcpFlagAck(boolean tcpFlagAck) {
        this.tcpFlagAck = tcpFlagAck;
    }

    public void setTcpFlagPsh(boolean tcpFlagPsh) {
        this.tcpFlagPsh = tcpFlagPsh;
    }

    public void setTcpFlagRst(boolean tcpFlagRst) {
        this.tcpFlagRst = tcpFlagRst;
    }

    public void setTcpFlagSyn(boolean tcpFlagSyn) {
        this.tcpFlagSyn = tcpFlagSyn;
    }

    public void setTcpFlagFin(boolean tcpFlagFin) {
        this.tcpFlagFin = tcpFlagFin;
    }

    public void setTcpWindowSize(int tcpWindowSize) {
        this.tcpWindowSize = tcpWindowSize;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public void setPayloadLength(int payloadLength) {
        this.payloadLength = payloadLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet)) {
            return false;
        }
        Packet other = (Packet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        if (this.getTsmicros() != other.getTsmicros()) {
            return false;
        }
        if (Double.compare(this.getTsUsec(), other.getTsUsec()) != 0) {
            return false;
        }
        if (this.getIpId() != other.getIpId()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getIpVersion() != other.getIpVersion()) {
            return false;
        }
        if (this.getIpHeaderLen() != other.getIpHeaderLen()) {
            return false;
        }
        if (this.getProtocol() != other.getProtocol()) {
            return false;
        }
        String this$src = this.getSrc();
        String other$src = other.getSrc();
        if (this$src == null ? other$src != null : !this$src.equals(other$src)) {
            return false;
        }
        String this$dst = this.getDst();
        String other$dst = other.getDst();
        if (this$dst == null ? other$dst != null : !this$dst.equals(other$dst)) {
            return false;
        }
        if (this.getFragOffset() != other.getFragOffset()) {
            return false;
        }
        if (this.isFragmented() != other.isFragmented()) {
            return false;
        }
        if (this.isLastFragment() != other.isLastFragment()) {
            return false;
        }
        if (this.getReassembledFragments() != other.getReassembledFragments()) {
            return false;
        }
        if (this.isFragmentFlagM() != other.isFragmentFlagM()) {
            return false;
        }
        if (this.getReassembledTCPFragments() != other.getReassembledTCPFragments()) {
            return false;
        }
        if (this.getSrcPort() != other.getSrcPort()) {
            return false;
        }
        if (this.getDstPort() != other.getDstPort()) {
            return false;
        }
        if (this.getTcpflow() != other.getTcpflow()) {
            return false;
        }
        if (this.getUdpsum() != other.getUdpsum()) {
            return false;
        }
        if (this.getUdpLength() != other.getUdpLength()) {
            return false;
        }
        if (this.getTcpHeaderLen() != other.getTcpHeaderLen()) {
            return false;
        }
        if (this.getTcpSeq() != other.getTcpSeq()) {
            return false;
        }
        if (this.getTcpAck() != other.getTcpAck()) {
            return false;
        }
        if (this.isTcpFlagNs() != other.isTcpFlagNs()) {
            return false;
        }
        if (this.isTcpFlagCwr() != other.isTcpFlagCwr()) {
            return false;
        }
        if (this.isTcpFlagEce() != other.isTcpFlagEce()) {
            return false;
        }
        if (this.isTcpFlagUrg() != other.isTcpFlagUrg()) {
            return false;
        }
        if (this.isTcpFlagAck() != other.isTcpFlagAck()) {
            return false;
        }
        if (this.isTcpFlagPsh() != other.isTcpFlagPsh()) {
            return false;
        }
        if (this.isTcpFlagRst() != other.isTcpFlagRst()) {
            return false;
        }
        if (this.isTcpFlagSyn() != other.isTcpFlagSyn()) {
            return false;
        }
        if (this.isTcpFlagFin() != other.isTcpFlagFin()) {
            return false;
        }
        if (this.getTcpWindowSize() != other.getTcpWindowSize()) {
            return false;
        }
        if (this.getTotalLength() != other.getTotalLength()) {
            return false;
        }
        return this.getPayloadLength() == other.getPayloadLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Packet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLen();
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        long $tsmicros = this.getTsmicros();
        result = result * 59 + (int)($tsmicros >>> 32 ^ $tsmicros);
        long $tsUsec = Double.doubleToLongBits(this.getTsUsec());
        result = result * 59 + (int)($tsUsec >>> 32 ^ $tsUsec);
        long $ipId = this.getIpId();
        result = result * 59 + (int)($ipId >>> 32 ^ $ipId);
        result = result * 59 + this.getTtl();
        result = result * 59 + this.getIpVersion();
        result = result * 59 + this.getIpHeaderLen();
        result = result * 59 + this.getProtocol();
        String $src = this.getSrc();
        result = result * 59 + ($src == null ? 43 : $src.hashCode());
        String $dst = this.getDst();
        result = result * 59 + ($dst == null ? 43 : $dst.hashCode());
        long $fragOffset = this.getFragOffset();
        result = result * 59 + (int)($fragOffset >>> 32 ^ $fragOffset);
        result = result * 59 + (this.isFragmented() ? 79 : 97);
        result = result * 59 + (this.isLastFragment() ? 79 : 97);
        result = result * 59 + this.getReassembledFragments();
        result = result * 59 + (this.isFragmentFlagM() ? 79 : 97);
        result = result * 59 + this.getReassembledTCPFragments();
        result = result * 59 + this.getSrcPort();
        result = result * 59 + this.getDstPort();
        result = result * 59 + this.getTcpflow();
        result = result * 59 + this.getUdpsum();
        result = result * 59 + this.getUdpLength();
        result = result * 59 + this.getTcpHeaderLen();
        long $tcpSeq = this.getTcpSeq();
        result = result * 59 + (int)($tcpSeq >>> 32 ^ $tcpSeq);
        long $tcpAck = this.getTcpAck();
        result = result * 59 + (int)($tcpAck >>> 32 ^ $tcpAck);
        result = result * 59 + (this.isTcpFlagNs() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagCwr() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagEce() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagUrg() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagAck() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagPsh() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagRst() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagSyn() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagFin() ? 79 : 97);
        result = result * 59 + this.getTcpWindowSize();
        result = result * 59 + this.getTotalLength();
        result = result * 59 + this.getPayloadLength();
        return result;
    }

    public String toString() {
        return "Packet(len=" + this.getLen() + ", ts=" + this.getTs() + ", tsmicros=" + this.getTsmicros() + ", tsUsec=" + this.getTsUsec() + ", ipId=" + this.getIpId() + ", ttl=" + this.getTtl() + ", ipVersion=" + this.getIpVersion() + ", ipHeaderLen=" + this.getIpHeaderLen() + ", protocol=" + this.getProtocol() + ", src=" + this.getSrc() + ", dst=" + this.getDst() + ", fragOffset=" + this.getFragOffset() + ", fragmented=" + this.isFragmented() + ", lastFragment=" + this.isLastFragment() + ", reassembledFragments=" + this.getReassembledFragments() + ", fragmentFlagM=" + this.isFragmentFlagM() + ", reassembledTCPFragments=" + this.getReassembledTCPFragments() + ", srcPort=" + this.getSrcPort() + ", dstPort=" + this.getDstPort() + ", tcpflow=" + this.getTcpflow() + ", udpsum=" + this.getUdpsum() + ", udpLength=" + this.getUdpLength() + ", tcpHeaderLen=" + this.getTcpHeaderLen() + ", tcpSeq=" + this.getTcpSeq() + ", tcpAck=" + this.getTcpAck() + ", tcpFlagNs=" + this.isTcpFlagNs() + ", tcpFlagCwr=" + this.isTcpFlagCwr() + ", tcpFlagEce=" + this.isTcpFlagEce() + ", tcpFlagUrg=" + this.isTcpFlagUrg() + ", tcpFlagAck=" + this.isTcpFlagAck() + ", tcpFlagPsh=" + this.isTcpFlagPsh() + ", tcpFlagRst=" + this.isTcpFlagRst() + ", tcpFlagSyn=" + this.isTcpFlagSyn() + ", tcpFlagFin=" + this.isTcpFlagFin() + ", tcpWindowSize=" + this.getTcpWindowSize() + ", totalLength=" + this.getTotalLength() + ", payloadLength=" + this.getPayloadLength() + ")";
    }
}

