/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import com.google.common.collect.ComparisonChain;
import java.util.Arrays;
import nl.sidnlabs.pcap.packet.TCPFlow;

public class SequencePayload
implements Comparable<SequencePayload> {
    private Long seq;
    private byte[] bytes;
    private long time;
    private long nextSequence;
    private boolean ignore;

    public SequencePayload() {
    }

    public SequencePayload(Long seq, byte[] bytes, long time, TCPFlow flow) {
        this.seq = seq;
        this.bytes = bytes;
        this.time = time;
        this.nextSequence = seq + (long)bytes.length;
    }

    @Override
    public int compareTo(SequencePayload o) {
        return ComparisonChain.start().compare((Comparable)this.seq, (Comparable)o.seq).compare(this.bytes.length, o.bytes.length).result();
    }

    public boolean linked(SequencePayload o) {
        if (this.nextSequence == o.seq) {
            return true;
        }
        return o.getNextSequence() == this.seq.longValue();
    }

    public Long getSeq() {
        return this.seq;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public long getTime() {
        return this.time;
    }

    public long getNextSequence() {
        return this.nextSequence;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setNextSequence(long nextSequence) {
        this.nextSequence = nextSequence;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequencePayload)) {
            return false;
        }
        SequencePayload other = (SequencePayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$seq = this.getSeq();
        Long other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        if (!Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getNextSequence() != other.getNextSequence()) {
            return false;
        }
        return this.isIgnore() == other.isIgnore();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequencePayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $nextSequence = this.getNextSequence();
        result = result * 59 + (int)($nextSequence >>> 32 ^ $nextSequence);
        result = result * 59 + (this.isIgnore() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SequencePayload(seq=" + this.getSeq() + ", time=" + this.getTime() + ", nextSequence=" + this.getNextSequence() + ", ignore=" + this.isIgnore() + ")";
    }
}

