/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import nl.sidnlabs.pcap.packet.Datagram;
import nl.sidnlabs.pcap.packet.TCPFlow;
import nl.sidnlabs.pcap.packet.TcpHandshake;

public class Packet {
    public static final Packet NULL = new Packet();
    protected int len;
    protected long tsSec;
    protected long tsMicro;
    protected long tsMilli;
    protected long ipId;
    protected int ttl;
    protected int ipVersion;
    protected int ipHeaderLen;
    protected byte protocol;
    protected String src;
    protected String dst;
    protected long fragOffset;
    protected boolean fragmented;
    protected boolean lastFragment;
    protected boolean doNotFragment;
    protected int reassembledFragments;
    protected boolean fragmentFlagM;
    protected int reassembledTCPFragments;
    protected int srcPort;
    protected int dstPort;
    protected int tcpflow;
    protected int tcpHeaderLen;
    protected long tcpSeq;
    protected long tcpAck;
    protected boolean tcpFlagNs;
    protected boolean tcpFlagCwr;
    protected boolean tcpFlagEce;
    protected boolean tcpFlagUrg;
    protected boolean tcpFlagAck;
    protected boolean tcpFlagPsh;
    protected boolean tcpFlagRst;
    protected boolean tcpFlagSyn;
    protected boolean tcpFlagFin;
    protected int tcpWindowSize;
    private int totalLength;
    protected int payloadLength;
    protected TcpHandshake tcpHandshake;
    private TCPFlow flow;
    private TCPFlow reverseFlow;

    public Packet() {
    }

    public Packet(byte protocol) {
        this.protocol = protocol;
    }

    public TCPFlow getFlow() {
        if (this.flow == null) {
            this.flow = new TCPFlow(this.src, this.srcPort, this.dst, this.dstPort, this.protocol);
        }
        return this.flow;
    }

    public TCPFlow getReverseFlow() {
        if (this.reverseFlow == null) {
            this.reverseFlow = new TCPFlow(this.dst, this.dstPort, this.src, this.srcPort, this.protocol);
        }
        return this.reverseFlow;
    }

    public Datagram getDatagram() {
        return new Datagram(this.getSrc(), this.getDst(), this.getIpId(), String.valueOf(this.getProtocol()), System.currentTimeMillis());
    }

    public boolean isIPv4() {
        return this.getIpVersion() == 4;
    }

    public boolean isIPv6() {
        return this.getIpVersion() == 6;
    }

    public long nextAck() {
        return this.tcpSeq + (long)this.payloadLength;
    }

    public int getLen() {
        return this.len;
    }

    public long getTsSec() {
        return this.tsSec;
    }

    public long getTsMicro() {
        return this.tsMicro;
    }

    public long getTsMilli() {
        return this.tsMilli;
    }

    public long getIpId() {
        return this.ipId;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getIpVersion() {
        return this.ipVersion;
    }

    public int getIpHeaderLen() {
        return this.ipHeaderLen;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public String getSrc() {
        return this.src;
    }

    public String getDst() {
        return this.dst;
    }

    public long getFragOffset() {
        return this.fragOffset;
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public boolean isLastFragment() {
        return this.lastFragment;
    }

    public boolean isDoNotFragment() {
        return this.doNotFragment;
    }

    public int getReassembledFragments() {
        return this.reassembledFragments;
    }

    public boolean isFragmentFlagM() {
        return this.fragmentFlagM;
    }

    public int getReassembledTCPFragments() {
        return this.reassembledTCPFragments;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public int getTcpflow() {
        return this.tcpflow;
    }

    public int getTcpHeaderLen() {
        return this.tcpHeaderLen;
    }

    public long getTcpSeq() {
        return this.tcpSeq;
    }

    public long getTcpAck() {
        return this.tcpAck;
    }

    public boolean isTcpFlagNs() {
        return this.tcpFlagNs;
    }

    public boolean isTcpFlagCwr() {
        return this.tcpFlagCwr;
    }

    public boolean isTcpFlagEce() {
        return this.tcpFlagEce;
    }

    public boolean isTcpFlagUrg() {
        return this.tcpFlagUrg;
    }

    public boolean isTcpFlagAck() {
        return this.tcpFlagAck;
    }

    public boolean isTcpFlagPsh() {
        return this.tcpFlagPsh;
    }

    public boolean isTcpFlagRst() {
        return this.tcpFlagRst;
    }

    public boolean isTcpFlagSyn() {
        return this.tcpFlagSyn;
    }

    public boolean isTcpFlagFin() {
        return this.tcpFlagFin;
    }

    public int getTcpWindowSize() {
        return this.tcpWindowSize;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public TcpHandshake getTcpHandshake() {
        return this.tcpHandshake;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setTsSec(long tsSec) {
        this.tsSec = tsSec;
    }

    public void setTsMicro(long tsMicro) {
        this.tsMicro = tsMicro;
    }

    public void setTsMilli(long tsMilli) {
        this.tsMilli = tsMilli;
    }

    public void setIpId(long ipId) {
        this.ipId = ipId;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setIpVersion(int ipVersion) {
        this.ipVersion = ipVersion;
    }

    public void setIpHeaderLen(int ipHeaderLen) {
        this.ipHeaderLen = ipHeaderLen;
    }

    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setFragOffset(long fragOffset) {
        this.fragOffset = fragOffset;
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    public void setLastFragment(boolean lastFragment) {
        this.lastFragment = lastFragment;
    }

    public void setDoNotFragment(boolean doNotFragment) {
        this.doNotFragment = doNotFragment;
    }

    public void setReassembledFragments(int reassembledFragments) {
        this.reassembledFragments = reassembledFragments;
    }

    public void setFragmentFlagM(boolean fragmentFlagM) {
        this.fragmentFlagM = fragmentFlagM;
    }

    public void setReassembledTCPFragments(int reassembledTCPFragments) {
        this.reassembledTCPFragments = reassembledTCPFragments;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public void setTcpflow(int tcpflow) {
        this.tcpflow = tcpflow;
    }

    public void setTcpHeaderLen(int tcpHeaderLen) {
        this.tcpHeaderLen = tcpHeaderLen;
    }

    public void setTcpSeq(long tcpSeq) {
        this.tcpSeq = tcpSeq;
    }

    public void setTcpAck(long tcpAck) {
        this.tcpAck = tcpAck;
    }

    public void setTcpFlagNs(boolean tcpFlagNs) {
        this.tcpFlagNs = tcpFlagNs;
    }

    public void setTcpFlagCwr(boolean tcpFlagCwr) {
        this.tcpFlagCwr = tcpFlagCwr;
    }

    public void setTcpFlagEce(boolean tcpFlagEce) {
        this.tcpFlagEce = tcpFlagEce;
    }

    public void setTcpFlagUrg(boolean tcpFlagUrg) {
        this.tcpFlagUrg = tcpFlagUrg;
    }

    public void setTcpFlagAck(boolean tcpFlagAck) {
        this.tcpFlagAck = tcpFlagAck;
    }

    public void setTcpFlagPsh(boolean tcpFlagPsh) {
        this.tcpFlagPsh = tcpFlagPsh;
    }

    public void setTcpFlagRst(boolean tcpFlagRst) {
        this.tcpFlagRst = tcpFlagRst;
    }

    public void setTcpFlagSyn(boolean tcpFlagSyn) {
        this.tcpFlagSyn = tcpFlagSyn;
    }

    public void setTcpFlagFin(boolean tcpFlagFin) {
        this.tcpFlagFin = tcpFlagFin;
    }

    public void setTcpWindowSize(int tcpWindowSize) {
        this.tcpWindowSize = tcpWindowSize;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public void setPayloadLength(int payloadLength) {
        this.payloadLength = payloadLength;
    }

    public void setTcpHandshake(TcpHandshake tcpHandshake) {
        this.tcpHandshake = tcpHandshake;
    }

    public void setFlow(TCPFlow flow) {
        this.flow = flow;
    }

    public void setReverseFlow(TCPFlow reverseFlow) {
        this.reverseFlow = reverseFlow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet)) {
            return false;
        }
        Packet other = (Packet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        if (this.getTsSec() != other.getTsSec()) {
            return false;
        }
        if (this.getTsMicro() != other.getTsMicro()) {
            return false;
        }
        if (this.getTsMilli() != other.getTsMilli()) {
            return false;
        }
        if (this.getIpId() != other.getIpId()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getIpVersion() != other.getIpVersion()) {
            return false;
        }
        if (this.getIpHeaderLen() != other.getIpHeaderLen()) {
            return false;
        }
        if (this.getProtocol() != other.getProtocol()) {
            return false;
        }
        String this$src = this.getSrc();
        String other$src = other.getSrc();
        if (this$src == null ? other$src != null : !this$src.equals(other$src)) {
            return false;
        }
        String this$dst = this.getDst();
        String other$dst = other.getDst();
        if (this$dst == null ? other$dst != null : !this$dst.equals(other$dst)) {
            return false;
        }
        if (this.getFragOffset() != other.getFragOffset()) {
            return false;
        }
        if (this.isFragmented() != other.isFragmented()) {
            return false;
        }
        if (this.isLastFragment() != other.isLastFragment()) {
            return false;
        }
        if (this.isDoNotFragment() != other.isDoNotFragment()) {
            return false;
        }
        if (this.getReassembledFragments() != other.getReassembledFragments()) {
            return false;
        }
        if (this.isFragmentFlagM() != other.isFragmentFlagM()) {
            return false;
        }
        if (this.getReassembledTCPFragments() != other.getReassembledTCPFragments()) {
            return false;
        }
        if (this.getSrcPort() != other.getSrcPort()) {
            return false;
        }
        if (this.getDstPort() != other.getDstPort()) {
            return false;
        }
        if (this.getTcpflow() != other.getTcpflow()) {
            return false;
        }
        if (this.getTcpHeaderLen() != other.getTcpHeaderLen()) {
            return false;
        }
        if (this.getTcpSeq() != other.getTcpSeq()) {
            return false;
        }
        if (this.getTcpAck() != other.getTcpAck()) {
            return false;
        }
        if (this.isTcpFlagNs() != other.isTcpFlagNs()) {
            return false;
        }
        if (this.isTcpFlagCwr() != other.isTcpFlagCwr()) {
            return false;
        }
        if (this.isTcpFlagEce() != other.isTcpFlagEce()) {
            return false;
        }
        if (this.isTcpFlagUrg() != other.isTcpFlagUrg()) {
            return false;
        }
        if (this.isTcpFlagAck() != other.isTcpFlagAck()) {
            return false;
        }
        if (this.isTcpFlagPsh() != other.isTcpFlagPsh()) {
            return false;
        }
        if (this.isTcpFlagRst() != other.isTcpFlagRst()) {
            return false;
        }
        if (this.isTcpFlagSyn() != other.isTcpFlagSyn()) {
            return false;
        }
        if (this.isTcpFlagFin() != other.isTcpFlagFin()) {
            return false;
        }
        if (this.getTcpWindowSize() != other.getTcpWindowSize()) {
            return false;
        }
        if (this.getTotalLength() != other.getTotalLength()) {
            return false;
        }
        if (this.getPayloadLength() != other.getPayloadLength()) {
            return false;
        }
        TcpHandshake this$tcpHandshake = this.getTcpHandshake();
        TcpHandshake other$tcpHandshake = other.getTcpHandshake();
        if (this$tcpHandshake == null ? other$tcpHandshake != null : !((Object)this$tcpHandshake).equals(other$tcpHandshake)) {
            return false;
        }
        TCPFlow this$flow = this.getFlow();
        TCPFlow other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !((Object)this$flow).equals(other$flow)) {
            return false;
        }
        TCPFlow this$reverseFlow = this.getReverseFlow();
        TCPFlow other$reverseFlow = other.getReverseFlow();
        return !(this$reverseFlow == null ? other$reverseFlow != null : !((Object)this$reverseFlow).equals(other$reverseFlow));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Packet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLen();
        long $tsSec = this.getTsSec();
        result = result * 59 + (int)($tsSec >>> 32 ^ $tsSec);
        long $tsMicro = this.getTsMicro();
        result = result * 59 + (int)($tsMicro >>> 32 ^ $tsMicro);
        long $tsMilli = this.getTsMilli();
        result = result * 59 + (int)($tsMilli >>> 32 ^ $tsMilli);
        long $ipId = this.getIpId();
        result = result * 59 + (int)($ipId >>> 32 ^ $ipId);
        result = result * 59 + this.getTtl();
        result = result * 59 + this.getIpVersion();
        result = result * 59 + this.getIpHeaderLen();
        result = result * 59 + this.getProtocol();
        String $src = this.getSrc();
        result = result * 59 + ($src == null ? 43 : $src.hashCode());
        String $dst = this.getDst();
        result = result * 59 + ($dst == null ? 43 : $dst.hashCode());
        long $fragOffset = this.getFragOffset();
        result = result * 59 + (int)($fragOffset >>> 32 ^ $fragOffset);
        result = result * 59 + (this.isFragmented() ? 79 : 97);
        result = result * 59 + (this.isLastFragment() ? 79 : 97);
        result = result * 59 + (this.isDoNotFragment() ? 79 : 97);
        result = result * 59 + this.getReassembledFragments();
        result = result * 59 + (this.isFragmentFlagM() ? 79 : 97);
        result = result * 59 + this.getReassembledTCPFragments();
        result = result * 59 + this.getSrcPort();
        result = result * 59 + this.getDstPort();
        result = result * 59 + this.getTcpflow();
        result = result * 59 + this.getTcpHeaderLen();
        long $tcpSeq = this.getTcpSeq();
        result = result * 59 + (int)($tcpSeq >>> 32 ^ $tcpSeq);
        long $tcpAck = this.getTcpAck();
        result = result * 59 + (int)($tcpAck >>> 32 ^ $tcpAck);
        result = result * 59 + (this.isTcpFlagNs() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagCwr() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagEce() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagUrg() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagAck() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagPsh() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagRst() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagSyn() ? 79 : 97);
        result = result * 59 + (this.isTcpFlagFin() ? 79 : 97);
        result = result * 59 + this.getTcpWindowSize();
        result = result * 59 + this.getTotalLength();
        result = result * 59 + this.getPayloadLength();
        TcpHandshake $tcpHandshake = this.getTcpHandshake();
        result = result * 59 + ($tcpHandshake == null ? 43 : ((Object)$tcpHandshake).hashCode());
        TCPFlow $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : ((Object)$flow).hashCode());
        TCPFlow $reverseFlow = this.getReverseFlow();
        result = result * 59 + ($reverseFlow == null ? 43 : ((Object)$reverseFlow).hashCode());
        return result;
    }

    public String toString() {
        return "Packet(len=" + this.getLen() + ", tsSec=" + this.getTsSec() + ", tsMicro=" + this.getTsMicro() + ", tsMilli=" + this.getTsMilli() + ", ipId=" + this.getIpId() + ", ttl=" + this.getTtl() + ", ipVersion=" + this.getIpVersion() + ", ipHeaderLen=" + this.getIpHeaderLen() + ", protocol=" + this.getProtocol() + ", src=" + this.getSrc() + ", dst=" + this.getDst() + ", fragOffset=" + this.getFragOffset() + ", fragmented=" + this.isFragmented() + ", lastFragment=" + this.isLastFragment() + ", doNotFragment=" + this.isDoNotFragment() + ", reassembledFragments=" + this.getReassembledFragments() + ", fragmentFlagM=" + this.isFragmentFlagM() + ", reassembledTCPFragments=" + this.getReassembledTCPFragments() + ", srcPort=" + this.getSrcPort() + ", dstPort=" + this.getDstPort() + ", tcpflow=" + this.getTcpflow() + ", tcpHeaderLen=" + this.getTcpHeaderLen() + ", tcpSeq=" + this.getTcpSeq() + ", tcpAck=" + this.getTcpAck() + ", tcpFlagNs=" + this.isTcpFlagNs() + ", tcpFlagCwr=" + this.isTcpFlagCwr() + ", tcpFlagEce=" + this.isTcpFlagEce() + ", tcpFlagUrg=" + this.isTcpFlagUrg() + ", tcpFlagAck=" + this.isTcpFlagAck() + ", tcpFlagPsh=" + this.isTcpFlagPsh() + ", tcpFlagRst=" + this.isTcpFlagRst() + ", tcpFlagSyn=" + this.isTcpFlagSyn() + ", tcpFlagFin=" + this.isTcpFlagFin() + ", tcpWindowSize=" + this.getTcpWindowSize() + ", totalLength=" + this.getTotalLength() + ", payloadLength=" + this.getPayloadLength() + ", tcpHandshake=" + this.getTcpHandshake() + ", flow=" + this.getFlow() + ", reverseFlow=" + this.getReverseFlow() + ")";
    }
}

