/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.sidnlabs.pcap.packet.SequencePayload;

public class FlowData {
    private long lastSequence;
    private long lastSize;
    private Set<SequencePayload> payloads = new HashSet<SequencePayload>();

    public void addPayload(SequencePayload p) {
        this.payloads.add(p);
        this.lastSequence = p.getSeq();
        this.lastSize = p.size();
    }

    public int size() {
        return this.payloads.size();
    }

    public List<SequencePayload> getSortedPayloads() {
        return this.payloads.stream().sorted().collect(Collectors.toList());
    }

    public List<SequencePayload> getPayloads() {
        return this.payloads.stream().collect(Collectors.toList());
    }

    public boolean isMinPayloadAvail() {
        for (SequencePayload p : this.payloads) {
            if (p.size() <= 2) continue;
            return true;
        }
        return false;
    }

    public long getNextExpectedSequence() {
        return this.lastSequence + this.lastSize;
    }

    public int getBytesAvail() {
        int sum = 0;
        for (SequencePayload p : this.payloads) {
            sum += p.size();
        }
        return sum;
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public long getLastSize() {
        return this.lastSize;
    }

    public void setLastSequence(long lastSequence) {
        this.lastSequence = lastSequence;
    }

    public void setLastSize(long lastSize) {
        this.lastSize = lastSize;
    }

    public void setPayloads(Set<SequencePayload> payloads) {
        this.payloads = payloads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowData)) {
            return false;
        }
        FlowData other = (FlowData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastSequence() != other.getLastSequence()) {
            return false;
        }
        if (this.getLastSize() != other.getLastSize()) {
            return false;
        }
        List<SequencePayload> this$payloads = this.getPayloads();
        List<SequencePayload> other$payloads = other.getPayloads();
        return !(this$payloads == null ? other$payloads != null : !((Object)this$payloads).equals(other$payloads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastSequence = this.getLastSequence();
        result = result * 59 + (int)($lastSequence >>> 32 ^ $lastSequence);
        long $lastSize = this.getLastSize();
        result = result * 59 + (int)($lastSize >>> 32 ^ $lastSize);
        List<SequencePayload> $payloads = this.getPayloads();
        result = result * 59 + ($payloads == null ? 43 : ((Object)$payloads).hashCode());
        return result;
    }

    public String toString() {
        return "FlowData(lastSequence=" + this.getLastSequence() + ", lastSize=" + this.getLastSize() + ", payloads=" + this.getPayloads() + ")";
    }
}

