/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

public class TcpHandshake {
    private HANDSHAKE_STATE state;
    private long synTs;
    private long ackTs;
    private long clientSynSeq;
    private long serverSynSeq;
    private long serverAckSeq;
    private long clientAckSeq;

    public TcpHandshake(long clientSynSeq) {
        this.state = HANDSHAKE_STATE.SYN_RECV;
        this.clientSynSeq = clientSynSeq;
    }

    public int rtt() {
        return (int)(this.ackTs - this.synTs);
    }

    public TcpHandshake() {
    }

    public HANDSHAKE_STATE getState() {
        return this.state;
    }

    public long getSynTs() {
        return this.synTs;
    }

    public long getAckTs() {
        return this.ackTs;
    }

    public long getClientSynSeq() {
        return this.clientSynSeq;
    }

    public long getServerSynSeq() {
        return this.serverSynSeq;
    }

    public long getServerAckSeq() {
        return this.serverAckSeq;
    }

    public long getClientAckSeq() {
        return this.clientAckSeq;
    }

    public void setState(HANDSHAKE_STATE state) {
        this.state = state;
    }

    public void setSynTs(long synTs) {
        this.synTs = synTs;
    }

    public void setAckTs(long ackTs) {
        this.ackTs = ackTs;
    }

    public void setClientSynSeq(long clientSynSeq) {
        this.clientSynSeq = clientSynSeq;
    }

    public void setServerSynSeq(long serverSynSeq) {
        this.serverSynSeq = serverSynSeq;
    }

    public void setServerAckSeq(long serverAckSeq) {
        this.serverAckSeq = serverAckSeq;
    }

    public void setClientAckSeq(long clientAckSeq) {
        this.clientAckSeq = clientAckSeq;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcpHandshake)) {
            return false;
        }
        TcpHandshake other = (TcpHandshake)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSynTs() != other.getSynTs()) {
            return false;
        }
        if (this.getAckTs() != other.getAckTs()) {
            return false;
        }
        if (this.getClientSynSeq() != other.getClientSynSeq()) {
            return false;
        }
        if (this.getServerSynSeq() != other.getServerSynSeq()) {
            return false;
        }
        if (this.getServerAckSeq() != other.getServerAckSeq()) {
            return false;
        }
        if (this.getClientAckSeq() != other.getClientAckSeq()) {
            return false;
        }
        HANDSHAKE_STATE this$state = this.getState();
        HANDSHAKE_STATE other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TcpHandshake;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $synTs = this.getSynTs();
        result = result * 59 + (int)($synTs >>> 32 ^ $synTs);
        long $ackTs = this.getAckTs();
        result = result * 59 + (int)($ackTs >>> 32 ^ $ackTs);
        long $clientSynSeq = this.getClientSynSeq();
        result = result * 59 + (int)($clientSynSeq >>> 32 ^ $clientSynSeq);
        long $serverSynSeq = this.getServerSynSeq();
        result = result * 59 + (int)($serverSynSeq >>> 32 ^ $serverSynSeq);
        long $serverAckSeq = this.getServerAckSeq();
        result = result * 59 + (int)($serverAckSeq >>> 32 ^ $serverAckSeq);
        long $clientAckSeq = this.getClientAckSeq();
        result = result * 59 + (int)($clientAckSeq >>> 32 ^ $clientAckSeq);
        HANDSHAKE_STATE $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "TcpHandshake(state=" + this.getState() + ", synTs=" + this.getSynTs() + ", ackTs=" + this.getAckTs() + ", clientSynSeq=" + this.getClientSynSeq() + ", serverSynSeq=" + this.getServerSynSeq() + ", serverAckSeq=" + this.getServerAckSeq() + ", clientAckSeq=" + this.getClientAckSeq() + ")";
    }

    public static enum HANDSHAKE_STATE {
        SYN_RECV,
        SYN_ACK_SENT,
        ACK_RECV;

    }
}

