/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PcapReaderUtil {
    private static final Logger log = LogManager.getLogger(PcapReaderUtil.class);

    private PcapReaderUtil() {
    }

    public static long convertInt(byte[] data) {
        return PcapReaderUtil.convertInt(data, false);
    }

    public static long convertInt(byte[] data, boolean reversed) {
        if (!reversed) {
            return (data[3] & 0xFF) << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        }
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public static long convertInt(byte[] data, int offset, boolean reversed) {
        byte[] target = new byte[4];
        System.arraycopy(data, offset, target, 0, target.length);
        return PcapReaderUtil.convertInt(target, reversed);
    }

    public static long convertInt(byte[] data, int offset) {
        byte[] target = new byte[4];
        System.arraycopy(data, offset, target, 0, target.length);
        return PcapReaderUtil.convertInt(target, false);
    }

    public static int convertShort(byte[] data) {
        return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    public static byte[] convertShort(int data) {
        byte[] result = new byte[]{(byte)(data >> 8), (byte)data};
        return result;
    }

    public static int convertShort(byte[] data, int offset) {
        byte[] target = new byte[2];
        System.arraycopy(data, offset, target, 0, target.length);
        return PcapReaderUtil.convertShort(target);
    }

    public static long convertUnsignedInt(byte[] data, int offset) {
        byte[] target = new byte[4];
        System.arraycopy(data, offset, target, 0, target.length);
        BigInteger placeholder = new BigInteger(1, target);
        return placeholder.longValue();
    }

    public static InetAddress convertDataToInetAddress(byte[] data, int offset, int size) {
        try {
            byte[] addr = new byte[size];
            System.arraycopy(data, offset, addr, 0, addr.length);
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            log.error("Ivalid host address: ", (Throwable)e);
            return null;
        }
    }

    public static short readUnsignedByte(byte[] buf, int index) {
        int byte1 = 0xFF & buf[index];
        return (short)byte1;
    }

    public static byte[] readPayload(byte[] packetData, int payloadDataStart, int payloadLength) {
        if (payloadLength < 0) {
            log.warn("Malformed packet - negative payload length. Returning empty payload.");
            return new byte[0];
        }
        if (payloadDataStart > packetData.length) {
            log.warn("Payload start (" + payloadDataStart + ") is larger than packet data (" + packetData.length + "). Returning empty payload.");
            return new byte[0];
        }
        if (payloadDataStart + payloadLength > packetData.length) {
            payloadLength = packetData.length - payloadDataStart;
        }
        byte[] data = new byte[payloadLength];
        System.arraycopy(packetData, payloadDataStart, data, 0, payloadLength);
        return data;
    }

    private static ByteBuffer reset(ByteBuffer buff, int limit) {
        buff.rewind();
        buff.limit(0);
        return buff;
    }

    public static ByteBuffer readPayloadToBuffer(byte[] packetData, int payloadDataStart, int payloadLength, ByteBuffer outBuffer) {
        if (payloadLength < 0) {
            log.warn("Malformed packet - negative payload length. Returning empty payload.");
            return PcapReaderUtil.reset(outBuffer, 0);
        }
        if (payloadDataStart > packetData.length) {
            log.warn("Payload start (" + payloadDataStart + ") is larger than packet data (" + packetData.length + "). Returning empty payload.");
            return PcapReaderUtil.reset(outBuffer, 0);
        }
        if (payloadDataStart + payloadLength > packetData.length) {
            payloadLength = packetData.length - payloadDataStart;
        }
        if (payloadLength == 0) {
            return PcapReaderUtil.reset(outBuffer, 0);
        }
        if (outBuffer.capacity() >= payloadLength) {
            outBuffer.limit(payloadLength);
            outBuffer.position(0);
            outBuffer.put(packetData, payloadDataStart, payloadLength);
            outBuffer.rewind();
            return outBuffer;
        }
        ByteBuffer out = ByteBuffer.allocate(payloadLength);
        out.put(packetData, payloadDataStart, payloadLength);
        out.rewind();
        return out;
    }
}

