/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import com.google.common.collect.ComparisonChain;

public class TCPFlow
implements Comparable<TCPFlow> {
    private String src;
    private int srcPort;
    private String dst;
    private int dstPort;
    private short protocol;

    public TCPFlow() {
    }

    public TCPFlow(String src, int srcPort, String dst, int dstPort, short protocol) {
        this.src = src;
        this.srcPort = srcPort;
        this.dst = dst;
        this.dstPort = dstPort;
        this.protocol = protocol;
    }

    @Override
    public int compareTo(TCPFlow o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.src), (Comparable)((Object)o.src)).compare(this.srcPort, o.srcPort).compare((Comparable)((Object)this.dst), (Comparable)((Object)o.dst)).compare(this.dstPort, o.dstPort).compare((int)this.protocol, (int)o.protocol).result();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dst == null ? 0 : this.dst.hashCode());
        result = 31 * result + this.dstPort;
        result = 31 * result + this.protocol;
        result = 31 * result + (this.src == null ? 0 : this.src.hashCode());
        result = 31 * result + this.srcPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCPFlow other = (TCPFlow)obj;
        if (this.dst == null ? other.dst != null : !this.dst.equals(other.dst)) {
            return false;
        }
        if (this.dstPort != other.dstPort) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        if (this.src == null ? other.src != null : !this.src.equals(other.src)) {
            return false;
        }
        return this.srcPort == other.srcPort;
    }

    public String getSrc() {
        return this.src;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public String getDst() {
        return this.dst;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public short getProtocol() {
        return this.protocol;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public void setProtocol(short protocol) {
        this.protocol = protocol;
    }
}

