/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.decoder.DNSDecoder;
import nl.sidnlabs.pcap.decoder.PacketReader;
import nl.sidnlabs.pcap.packet.DNSPacket;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.util.UDPUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UDPDecoder
implements PacketReader {
    private static final Logger log = LogManager.getLogger(UDPDecoder.class);
    private DNSDecoder dnsDecoder;

    public UDPDecoder() {
        this(false);
    }

    public UDPDecoder(boolean allowfail) {
        this.dnsDecoder = new DNSDecoder(allowfail);
    }

    @Override
    public Packet reassemble(Packet packet, byte[] packetData) {
        packet.setSrcPort(PcapReaderUtil.convertShort(packetData, 0));
        packet.setDstPort(PcapReaderUtil.convertShort(packetData, 2));
        if (!this.isDNS(packet)) {
            if (log.isDebugEnabled()) {
                log.debug("Packet is not a DNS packet: " + packet);
            }
            return Packet.NULL;
        }
        byte[] packetPayload = this.decode(packetData);
        if (packetPayload.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug("No valid DNS packet found: " + packet);
            }
            return Packet.NULL;
        }
        packet.setLen(packetData.length);
        packet.setPayloadLength(UDPUtil.getUdpLen(packetData));
        return this.dnsDecoder.decode((DNSPacket)packet, packetPayload);
    }

    public byte[] decode(byte[] packetData) {
        int payloadLength = packetData.length - 8;
        return PcapReaderUtil.readPayload(packetData, 8, payloadLength);
    }

    public DNSDecoder getDnsDecoder() {
        return this.dnsDecoder;
    }

    public void setDnsDecoder(DNSDecoder dnsDecoder) {
        this.dnsDecoder = dnsDecoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UDPDecoder)) {
            return false;
        }
        UDPDecoder other = (UDPDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DNSDecoder this$dnsDecoder = this.getDnsDecoder();
        DNSDecoder other$dnsDecoder = other.getDnsDecoder();
        return !(this$dnsDecoder == null ? other$dnsDecoder != null : !((Object)this$dnsDecoder).equals(other$dnsDecoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UDPDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DNSDecoder $dnsDecoder = this.getDnsDecoder();
        result = result * 59 + ($dnsDecoder == null ? 43 : ((Object)$dnsDecoder).hashCode());
        return result;
    }

    public String toString() {
        return "UDPDecoder(dnsDecoder=" + this.getDnsDecoder() + ")";
    }
}

