/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import com.google.common.collect.ComparisonChain;
import java.util.Arrays;

public class DatagramPayload
implements Comparable<DatagramPayload> {
    private long offset;
    private byte[] payload;

    public DatagramPayload(Long offset, byte[] payload) {
        this.offset = offset;
        this.payload = payload;
    }

    @Override
    public int compareTo(DatagramPayload o) {
        return ComparisonChain.start().compare(this.offset, o.offset).compare(this.payload.length, o.payload.length).result();
    }

    public boolean linked(DatagramPayload o) {
        if (this.offset + (long)this.payload.length == o.offset) {
            return true;
        }
        return o.offset + (long)o.payload.length == this.offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatagramPayload)) {
            return false;
        }
        DatagramPayload other = (DatagramPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatagramPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    public String toString() {
        return "DatagramPayload(offset=" + this.getOffset() + ")";
    }
}

