/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.sidnlabs.pcap.SequencePayload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowData {
    private static final Logger log = LogManager.getLogger(FlowData.class);
    private int nextDnsMsgLen;
    private int bytesAvail;
    private long lastSequence;
    private Set<SequencePayload> payloads = new HashSet<SequencePayload>();

    public boolean addPayload(SequencePayload p) {
        if (p.getSeq() > this.lastSequence) {
            this.payloads.add(p);
            this.lastSequence = p.getSeq();
            return true;
        }
        log.warn("Received out-of-order sequence, ignoring: {}", (Object)p);
        return false;
    }

    public int size() {
        return this.payloads.size();
    }

    public List<SequencePayload> getSortedPayloads() {
        return this.payloads.stream().sorted().collect(Collectors.toList());
    }

    public boolean isNextPayloadAvail() {
        return this.bytesAvail >= this.nextDnsMsgLen + 2;
    }

    public int getNextDnsMsgLen() {
        return this.nextDnsMsgLen;
    }

    public int getBytesAvail() {
        return this.bytesAvail;
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public Set<SequencePayload> getPayloads() {
        return this.payloads;
    }

    public void setNextDnsMsgLen(int nextDnsMsgLen) {
        this.nextDnsMsgLen = nextDnsMsgLen;
    }

    public void setBytesAvail(int bytesAvail) {
        this.bytesAvail = bytesAvail;
    }

    public void setLastSequence(long lastSequence) {
        this.lastSequence = lastSequence;
    }

    public void setPayloads(Set<SequencePayload> payloads) {
        this.payloads = payloads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowData)) {
            return false;
        }
        FlowData other = (FlowData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNextDnsMsgLen() != other.getNextDnsMsgLen()) {
            return false;
        }
        if (this.getBytesAvail() != other.getBytesAvail()) {
            return false;
        }
        if (this.getLastSequence() != other.getLastSequence()) {
            return false;
        }
        Set<SequencePayload> this$payloads = this.getPayloads();
        Set<SequencePayload> other$payloads = other.getPayloads();
        return !(this$payloads == null ? other$payloads != null : !((Object)this$payloads).equals(other$payloads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNextDnsMsgLen();
        result = result * 59 + this.getBytesAvail();
        long $lastSequence = this.getLastSequence();
        result = result * 59 + (int)($lastSequence >>> 32 ^ $lastSequence);
        Set<SequencePayload> $payloads = this.getPayloads();
        result = result * 59 + ($payloads == null ? 43 : ((Object)$payloads).hashCode());
        return result;
    }

    public String toString() {
        return "FlowData(nextDnsMsgLen=" + this.getNextDnsMsgLen() + ", bytesAvail=" + this.getBytesAvail() + ", lastSequence=" + this.getLastSequence() + ", payloads=" + this.getPayloads() + ")";
    }
}

