/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.sidnlabs.pcap.decoder.Buffer;

public class ChainBuffer
implements Buffer {
    private List<byte[]> buffers = new ArrayList<byte[]>();
    private int baseIndex;
    private int baseOffset;
    private int markIndex = -1;
    private int markOffset = -1;
    private int bufIndex = 0;
    private int bufOffset = 0;

    public ChainBuffer() {
        this.baseIndex = 0;
        this.baseOffset = 0;
    }

    public ChainBuffer(byte[] b) {
        this();
        this.addLast(b);
    }

    public ChainBuffer(Buffer other) {
        this.buffers.addAll(other.getBuffers());
        int[] metaData = other.getMetaData();
        this.baseIndex = metaData[0];
        this.baseOffset = metaData[1];
        this.markIndex = metaData[2];
        this.markOffset = metaData[3];
        this.bufIndex = metaData[4];
        this.bufOffset = metaData[5];
    }

    @Override
    public int[] getMetaData() {
        return new int[]{this.baseIndex, this.baseOffset, this.markIndex, this.markOffset, this.bufIndex, this.bufOffset};
    }

    @Override
    public List<byte[]> getBuffers() {
        return this.buffers;
    }

    @Override
    public int getCapacity() {
        int capacity = 0;
        for (byte[] b : this.buffers) {
            capacity += b.length;
        }
        return capacity;
    }

    @Override
    public int getBaseIndex() {
        return this.baseIndex;
    }

    @Override
    public int getBaseOffset() {
        return this.baseOffset;
    }

    @Override
    public int getBufIndex() {
        return this.bufIndex;
    }

    @Override
    public int getOffset() {
        return this.bufOffset;
    }

    @Override
    public int position() {
        int absPos = 0;
        if (this.bufIndex > 0) {
            int loopCount = 0;
            for (byte[] buffer : this.buffers) {
                absPos += buffer.length;
                if (loopCount >= this.bufIndex - 1) break;
                ++loopCount;
            }
        }
        return absPos += this.bufOffset;
    }

    @Override
    public Buffer position(int newPosition) {
        int absPos = 0;
        int i = 0;
        if (newPosition < 0) {
            throw new IllegalArgumentException();
        }
        for (byte[] buffer : this.buffers) {
            if (absPos + buffer.length >= newPosition) {
                this.bufIndex = i;
                this.bufOffset = newPosition - absPos;
                return this;
            }
            absPos += buffer.length;
            ++i;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addFirst(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        this.buffers.add(0, buffer);
    }

    @Override
    public void addLast(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        this.buffers.add(buffer);
    }

    @Override
    public void addFirst(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        List<byte[]> newBufList = buffer.getBuffers();
        this.buffers.addAll(0, newBufList);
    }

    @Override
    public void addLast(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        List<byte[]> l = buffer.getBuffers();
        int i = buffer.getBaseIndex();
        int j = buffer.getBaseOffset();
        if (i >= l.size()) {
            return;
        }
        byte[] b = l.get(i);
        if (j > 0) {
            byte[] t = new byte[b.length - j];
            for (int k = 0; k < t.length; ++k) {
                t[k] = b[k + j];
            }
            this.buffers.add(t);
            if (i + 1 < l.size()) {
                this.buffers.addAll(l.subList(i + 1, l.size()));
            }
        } else if (i < l.size()) {
            this.buffers.addAll(l.subList(i, l.size()));
        }
    }

    @Override
    public void addLast(Buffer buffer, int length) {
        if (buffer == null) {
            return;
        }
        List<byte[]> l = buffer.getBuffers();
        int i = buffer.getBufIndex();
        int j = buffer.getOffset();
        if (i >= l.size() || length <= 0) {
            return;
        }
        buffer.mark();
        if (buffer.skip(length) == null) {
            return;
        }
        int m = buffer.getBufIndex();
        int n = buffer.getOffset();
        buffer.reset();
        byte[] b = l.get(i);
        if (j > 0) {
            if (m == i) {
                byte[] t = new byte[n - j];
                for (int k = 0; k < t.length; ++k) {
                    t[k] = b[k + j];
                }
                this.buffers.add(t);
            } else if (m == i + 1) {
                byte[] t = new byte[b.length - j];
                for (int k = 0; k < t.length; ++k) {
                    t[k] = b[k + j];
                }
                this.buffers.add(t);
                if (n > 0) {
                    byte[] b1 = l.get(m);
                    byte[] t1 = new byte[n];
                    for (int k = 0; k < t1.length; ++k) {
                        t1[k] = b1[k];
                    }
                    this.buffers.add(t1);
                }
            } else {
                byte[] t = new byte[b.length - j];
                for (int k = 0; k < t.length; ++k) {
                    t[k] = b[k + j];
                }
                this.buffers.add(t);
                if (i + 1 == m - 1) {
                    this.buffers.add(l.get(i + 1));
                } else {
                    this.buffers.addAll(l.subList(i + 1, m));
                }
                if (n > 0) {
                    byte[] b1 = l.get(m);
                    byte[] t1 = new byte[n];
                    for (int k = 0; k < t1.length; ++k) {
                        t1[k] = b1[k];
                    }
                    this.buffers.add(t1);
                }
            }
        } else if (m == i) {
            byte[] t1 = new byte[n];
            for (int k = 0; k < t1.length; ++k) {
                t1[k] = b[k];
            }
            this.buffers.add(t1);
        } else if (i == m - 1) {
            this.buffers.add(b);
            if (n > 0) {
                byte[] b1 = l.get(m);
                byte[] t1 = new byte[n];
                for (int k = 0; k < t1.length; ++k) {
                    t1[k] = b1[k];
                }
                this.buffers.add(t1);
            }
        } else {
            this.buffers.addAll(l.subList(i, m));
            if (n > 0) {
                byte[] b1 = l.get(m);
                byte[] t1 = new byte[n];
                for (int k = 0; k < t1.length; ++k) {
                    t1[k] = b1[k];
                }
                this.buffers.add(t1);
            }
        }
    }

    @Override
    public Buffer skip(int pos) {
        int i;
        byte[] buf;
        int next;
        if (pos <= 0) {
            return null;
        }
        int skipped = 0;
        if ((skipped += (next = (buf = this.buffers.get(i = this.bufIndex++)).length - this.bufOffset)) >= pos) {
            this.bufOffset += pos;
            if (this.bufOffset >= buf.length) {
                this.bufOffset = 0;
            }
            return this;
        }
        ++i;
        while (i < this.buffers.size()) {
            next = this.buffers.get(i).length;
            if ((skipped += next) >= pos) {
                int remain = skipped - pos;
                this.bufIndex = i;
                this.bufOffset = next - remain;
                if (this.bufOffset >= next) {
                    ++this.bufIndex;
                    this.bufOffset = 0;
                }
                return this;
            }
            ++i;
        }
        return null;
    }

    @Override
    public byte get() throws BufferUnderflowException {
        if (this.bufIndex >= this.buffers.size()) {
            throw new BufferUnderflowException();
        }
        byte[] buf = this.buffers.get(this.bufIndex);
        if (this.bufOffset >= buf.length) {
            this.bufOffset = 0;
            ++this.bufIndex;
            if (this.bufIndex >= this.buffers.size()) {
                throw new BufferUnderflowException();
            }
            buf = this.buffers.get(this.bufIndex);
        }
        byte retVal = buf[this.bufOffset];
        if (this.bufOffset + 1 >= buf.length) {
            ++this.bufIndex;
            this.bufOffset = 0;
        } else {
            ++this.bufOffset;
        }
        return retVal;
    }

    @Override
    public short getShort() throws BufferUnderflowException {
        byte[] b = new byte[2];
        this.gets(b, 0, 2);
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            s = (short)(s << 8);
            s = (short)((long)s ^ (long)b[i] & 0xFFL);
        }
        return s;
    }

    @Override
    public int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    @Override
    public int getInt() throws BufferUnderflowException {
        byte[] b = new byte[4];
        this.gets(b, 0, 4);
        int s = 0;
        for (int i = 0; i < 4; ++i) {
            s <<= 8;
            s = (int)((long)s ^ (long)b[i] & 0xFFL);
        }
        return s;
    }

    @Override
    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public long getLong() throws BufferUnderflowException {
        byte[] b = new byte[8];
        this.gets(b, 0, 8);
        long s = 0L;
        for (int i = 0; i < 8; ++i) {
            s <<= 8;
            s ^= (long)b[i] & 0xFFL;
        }
        return s;
    }

    @Override
    public String getString(int length) throws BufferUnderflowException {
        byte[] str = new byte[length];
        this.gets(str, 0, length);
        return new String(str);
    }

    @Override
    public String getString(int length, String charsetName) throws BufferUnderflowException {
        byte[] str = new byte[length];
        try {
            this.gets(str, 0, length);
            return new String(str, charsetName);
        }
        catch (BufferUnderflowException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            return new String(str);
        }
    }

    @Override
    public String getString(int length, Charset charset) throws BufferUnderflowException {
        byte[] str = new byte[length];
        this.gets(str, 0, length);
        return new String(str, charset);
    }

    @Override
    public void gets(byte[] buffer) {
        this.gets(buffer, 0, buffer.length);
    }

    @Override
    public void gets(byte[] buffer, int offset, int length) throws BufferUnderflowException {
        if (length == 0) {
            return;
        }
        if (this.bufIndex >= this.buffers.size()) {
            throw new BufferUnderflowException();
        }
        int remain = this.readableBytes();
        if (remain < length) {
            throw new BufferUnderflowException();
        }
        int index = offset;
        int i = 0;
        int j = this.bufIndex;
        int bufI = this.bufIndex;
        int off = this.bufOffset;
        int bufCount = 0;
        int count = 0;
        for (byte[] b : this.buffers) {
            if (bufCount < j) {
                ++bufCount;
                continue;
            }
            for (i = off; i < b.length; ++i) {
                if (count == length) {
                    off = i;
                    break;
                }
                buffer[index] = b[i];
                ++index;
                ++count;
            }
            if (count == length) {
                if (i != b.length) break;
                ++bufI;
                off = 0;
                break;
            }
            ++bufI;
            off = 0;
        }
        this.bufIndex = bufI;
        this.bufOffset = off;
    }

    @Override
    public int bytesBefore(byte[] target) {
        this.mark();
        int stateNum = 0;
        int length = 0;
        if (this.bufIndex >= this.buffers.size()) {
            this.reset();
            return 0;
        }
        byte[] bs = this.buffers.get(this.bufIndex);
        for (int i = this.bufOffset; i < bs.length; ++i) {
            stateNum = bs[i] == target[stateNum] ? ++stateNum : (bs[i] == target[0] ? 1 : 0);
            ++length;
            if (stateNum != target.length) continue;
            this.reset();
            return length - target.length;
        }
        int index = this.bufIndex + 1;
        List<byte[]> subList = this.buffers.subList(index, this.buffers.size());
        for (byte[] bs2 : subList) {
            for (byte b : bs2) {
                stateNum = b == target[stateNum] ? ++stateNum : (b == target[0] ? 1 : 0);
                ++length;
                if (stateNum != target.length) continue;
                this.reset();
                return length - target.length;
            }
        }
        this.reset();
        return 0;
    }

    @Override
    public void mark() {
        this.markIndex = this.bufIndex;
        this.markOffset = this.bufOffset;
    }

    @Override
    public void rewind() {
        this.bufIndex = this.baseIndex;
        this.bufOffset = this.baseOffset;
        this.markIndex = -1;
        this.markOffset = -1;
    }

    @Override
    public Buffer reset() {
        if (this.markIndex == -1 && this.markOffset == -1) {
            throw new InvalidMarkException();
        }
        if (this.bufIndex > this.markIndex) {
            int rewindOffset = this.bufOffset;
            for (int i = this.bufIndex - 1; i > this.markIndex; --i) {
                byte[] buf = this.buffers.get(i);
                rewindOffset += buf.length;
            }
            byte[] markBuf = this.buffers.get(this.markIndex);
            return this.reset(rewindOffset += markBuf.length - this.markOffset);
        }
        if (this.bufIndex < this.markIndex) {
            int absPos = 0;
            for (int i = this.bufIndex + 1; i < this.markIndex; ++i) {
                absPos += this.buffers.get(i).length;
            }
            absPos += this.buffers.get(this.bufIndex).length - this.bufOffset;
            return this.skip(absPos += this.markOffset);
        }
        if (this.bufOffset > this.markOffset) {
            return this.reset(this.bufOffset - this.markOffset);
        }
        return this.skip(this.markOffset - this.bufOffset);
    }

    public Buffer reset(int rewindOffset) {
        if (this.bufIndex > this.baseIndex) {
            if (this.bufOffset >= rewindOffset) {
                this.bufOffset -= rewindOffset;
            } else {
                byte[] b;
                int i = this.bufIndex;
                int sumOffset = this.bufOffset;
                while ((sumOffset += (b = this.buffers.get(--i)).length) < rewindOffset && i > 0) {
                }
                if (sumOffset < rewindOffset) {
                    return null;
                }
                this.bufIndex = i;
                this.bufOffset = sumOffset - rewindOffset;
            }
        } else if (this.bufOffset >= rewindOffset) {
            this.bufOffset -= rewindOffset;
        } else {
            return null;
        }
        return this;
    }

    public void clean() {
        if (this.bufIndex == 0) {
            return;
        }
        for (int count = 0; count < this.bufIndex; ++count) {
            this.buffers.remove(0);
        }
        this.bufIndex = 0;
    }

    @Override
    public void discardReadBytes() {
        if (this.bufIndex >= this.buffers.size()) {
            return;
        }
        byte[] buf = this.buffers.get(this.bufIndex);
        if (this.bufOffset >= buf.length) {
            ++this.bufIndex;
            this.bufOffset = 0;
        }
        this.baseIndex = this.bufIndex;
        this.baseOffset = this.bufOffset;
    }

    @Override
    public byte[] currentBuffer() {
        return this.buffers.get(this.bufIndex);
    }

    @Override
    public int readableBytesCurrentBuffer() {
        byte[] buf = this.buffers.get(this.bufIndex);
        return buf.length - this.bufOffset;
    }

    @Override
    public int readableBytes() {
        if (this.buffers.size() <= 0 || this.isEOB()) {
            return 0;
        }
        byte[] buf = this.buffers.get(this.bufIndex);
        int remain = buf.length - this.bufOffset;
        for (int i = this.bufIndex + 1; i < this.buffers.size(); ++i) {
            buf = this.buffers.get(i);
            remain += buf.length;
        }
        return remain;
    }

    @Override
    public Buffer clear() {
        this.baseIndex = 0;
        this.baseOffset = 0;
        this.bufIndex = 0;
        this.bufOffset = 0;
        this.markIndex = -1;
        this.markOffset = -1;
        return this;
    }

    @Override
    public boolean isEOB() {
        return this.bufIndex >= this.buffers.size();
    }

    @Override
    public Buffer duplicate() {
        return null;
    }

    @Override
    public Buffer flip() {
        int i = this.bufIndex + 1;
        while (i < this.buffers.size()) {
            this.buffers.remove(i);
        }
        if (this.bufIndex >= this.buffers.size()) {
            this.bufIndex = this.baseIndex;
            this.bufOffset = this.baseOffset;
            this.markIndex = -1;
            this.markOffset = -1;
            return this;
        }
        byte[] b = this.buffers.get(this.bufIndex);
        byte[] newb = Arrays.copyOf(b, this.bufOffset);
        this.buffers.remove(this.bufIndex);
        this.buffers.add(this.bufIndex, newb);
        this.bufIndex = this.baseIndex;
        this.bufOffset = this.baseOffset;
        this.markIndex = -1;
        this.markOffset = -1;
        return this;
    }
}

